/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeAttributes;

public class ViewAttributes
extends NodeAttributes
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=373");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=375");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=374");
    private final Boolean containsNoLoops;
    private final UByte eventNotifier;

    public ViewAttributes(UInteger specifiedAttributes, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean containsNoLoops, UByte eventNotifier) {
        super(specifiedAttributes, displayName, description, writeMask, userWriteMask);
        this.containsNoLoops = containsNoLoops;
        this.eventNotifier = eventNotifier;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getContainsNoLoops() {
        return this.containsNoLoops;
    }

    public UByte getEventNotifier() {
        return this.eventNotifier;
    }

    protected ViewAttributes(ViewAttributesBuilder<?, ?> b) {
        super((NodeAttributes.NodeAttributesBuilder<?, ?>)b);
        this.containsNoLoops = ((ViewAttributesBuilder)b).containsNoLoops;
        this.eventNotifier = ((ViewAttributesBuilder)b).eventNotifier;
    }

    public static ViewAttributesBuilder<?, ?> builder() {
        return new ViewAttributesBuilderImpl();
    }

    public ViewAttributesBuilder<?, ?> toBuilder() {
        return new ViewAttributesBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewAttributes)) {
            return false;
        }
        ViewAttributes other = (ViewAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$containsNoLoops = this.getContainsNoLoops();
        Boolean other$containsNoLoops = other.getContainsNoLoops();
        if (this$containsNoLoops == null ? other$containsNoLoops != null : !((Object)this$containsNoLoops).equals(other$containsNoLoops)) {
            return false;
        }
        UByte this$eventNotifier = this.getEventNotifier();
        UByte other$eventNotifier = other.getEventNotifier();
        return !(this$eventNotifier == null ? other$eventNotifier != null : !((Object)this$eventNotifier).equals(other$eventNotifier));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ViewAttributes;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $containsNoLoops = this.getContainsNoLoops();
        result = result * 59 + ($containsNoLoops == null ? 43 : ((Object)$containsNoLoops).hashCode());
        UByte $eventNotifier = this.getEventNotifier();
        result = result * 59 + ($eventNotifier == null ? 43 : ((Object)$eventNotifier).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ViewAttributes(containsNoLoops=" + this.getContainsNoLoops() + ", eventNotifier=" + this.getEventNotifier() + ")";
    }

    private static final class ViewAttributesBuilderImpl
    extends ViewAttributesBuilder<ViewAttributes, ViewAttributesBuilderImpl> {
        private ViewAttributesBuilderImpl() {
        }

        @Override
        protected ViewAttributesBuilderImpl self() {
            return this;
        }

        @Override
        public ViewAttributes build() {
            return new ViewAttributes(this);
        }
    }

    public static abstract class ViewAttributesBuilder<C extends ViewAttributes, B extends ViewAttributesBuilder<C, B>>
    extends NodeAttributes.NodeAttributesBuilder<C, B> {
        private Boolean containsNoLoops;
        private UByte eventNotifier;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ViewAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ViewAttributes instance, ViewAttributesBuilder<?, ?> b) {
            b.containsNoLoops(instance.containsNoLoops);
            b.eventNotifier(instance.eventNotifier);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B containsNoLoops(Boolean containsNoLoops) {
            this.containsNoLoops = containsNoLoops;
            return (B)this.self();
        }

        public B eventNotifier(UByte eventNotifier) {
            this.eventNotifier = eventNotifier;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ViewAttributes.ViewAttributesBuilder(super=" + super.toString() + ", containsNoLoops=" + this.containsNoLoops + ", eventNotifier=" + this.eventNotifier + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ViewAttributes> {
        @Override
        public Class<ViewAttributes> getType() {
            return ViewAttributes.class;
        }

        @Override
        public ViewAttributes decode(SerializationContext context, UaDecoder decoder) {
            UInteger specifiedAttributes = decoder.readUInt32("SpecifiedAttributes");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            Boolean containsNoLoops = decoder.readBoolean("ContainsNoLoops");
            UByte eventNotifier = decoder.readByte("EventNotifier");
            return new ViewAttributes(specifiedAttributes, displayName, description, writeMask, userWriteMask, containsNoLoops, eventNotifier);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ViewAttributes value) {
            encoder.writeUInt32("SpecifiedAttributes", value.getSpecifiedAttributes());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeBoolean("ContainsNoLoops", value.getContainsNoLoops());
            encoder.writeByte("EventNotifier", value.getEventNotifier());
        }
    }
}

