/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum TrustListMasks implements UaEnumeration
{
    None(0),
    TrustedCertificates(1),
    TrustedCrls(2),
    IssuerCertificates(4),
    IssuerCrls(8),
    All(15);

    private final int value;

    private TrustListMasks(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static TrustListMasks from(int value) {
        switch (value) {
            case 0: {
                return None;
            }
            case 1: {
                return TrustedCertificates;
            }
            case 2: {
                return TrustedCrls;
            }
            case 4: {
                return IssuerCertificates;
            }
            case 8: {
                return IssuerCrls;
            }
            case 15: {
                return All;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12552");
    }

    public static class Codec
    extends GenericDataTypeCodec<TrustListMasks> {
        @Override
        public Class<TrustListMasks> getType() {
            return TrustListMasks.class;
        }

        @Override
        public TrustListMasks decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, TrustListMasks.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, TrustListMasks value) {
            encoder.writeEnum(null, value);
        }
    }
}

