/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.memory.IMemoryBlock;
import org.apache.iotdb.commons.memory.MemoryBlockType;
import org.apache.iotdb.commons.path.ExtendedPartialPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCacheBuilder;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCachePolicy;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.IDeviceSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceCacheEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCacheMetrics;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableId;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.StringArrayDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TableDeviceSchemaCache {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final DataNodeMemoryConfig memoryConfig = IoTDBDescriptor.getInstance().getMemoryConfig();
    private static final Logger logger = LoggerFactory.getLogger(TableDeviceSchemaCache.class);
    private final IDualKeyCache<TableId, IDeviceID, TableDeviceCacheEntry> dualKeyCache;
    private final Map<String, String> treeModelDatabasePool = new ConcurrentHashMap<String, String>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);
    private final IMemoryBlock memoryBlock = memoryConfig.getSchemaCacheMemoryManager().exactAllocate("TableDeviceSchemaCache", MemoryBlockType.STATIC);

    private TableDeviceSchemaCache() {
        this.dualKeyCache = new DualKeyCacheBuilder().cacheEvictionPolicy(DualKeyCachePolicy.valueOf(config.getDataNodeSchemaCacheEvictionPolicy())).memoryCapacity(this.memoryBlock.getTotalMemorySizeInBytes()).firstKeySizeComputer(TableId::estimateSize).secondKeySizeComputer(deviceID -> (int)deviceID.ramBytesUsed()).valueSizeComputer(TableDeviceCacheEntry::estimateSize).build();
        this.memoryBlock.allocate(this.memoryBlock.getTotalMemorySizeInBytes());
        MetricService.getInstance().addMetricSet((IMetricSet)new TableDeviceSchemaCacheMetrics(this));
    }

    public static TableDeviceSchemaCache getInstance() {
        return TableDeviceSchemaCacheHolder.INSTANCE;
    }

    public Map<String, Binary> getDeviceAttribute(String database, IDeviceID deviceId) {
        TableDeviceCacheEntry entry = this.dualKeyCache.get(new TableId(database, deviceId.getTableName()), deviceId);
        return entry == null ? null : entry.getAttributeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAttributes(String database, IDeviceID deviceId, Map<String, Binary> attributeMap) {
        this.readWriteLock.readLock().lock();
        try {
            if (Objects.isNull(DataNodeTableCache.getInstance().getTable(database, deviceId.getTableName()))) {
                return;
            }
            this.dualKeyCache.update(new TableId(database, deviceId.getTableName()), deviceId, new TableDeviceCacheEntry(), entry -> entry.setAttribute(database, deviceId.getTableName(), attributeMap), true);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void updateAttributes(String database, IDeviceID deviceId, Map<String, Binary> attributeMap) {
        this.dualKeyCache.update(new TableId(database, deviceId.getTableName()), deviceId, null, entry -> entry.updateAttribute(database, deviceId.getTableName(), attributeMap), false);
    }

    public void invalidateAttributes(String database, String tableName) {
        this.dualKeyCache.update(new TableId(database, tableName), deviceId -> true, entry -> -entry.invalidateAttribute());
    }

    public void invalidateAttributes(String database, IDeviceID deviceId) {
        this.dualKeyCache.update(new TableId(database, deviceId.getTableName()), deviceId, null, entry -> -entry.invalidateAttribute(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOrInvalidateLastCache(String database, IDeviceID deviceId, String[] measurements, boolean isInvalidate) {
        this.readWriteLock.readLock().lock();
        try {
            if (Objects.isNull(DataNodeTableCache.getInstance().getTable(database, deviceId.getTableName()))) {
                return;
            }
            this.dualKeyCache.update(new TableId(database, deviceId.getTableName()), deviceId, new TableDeviceCacheEntry(), entry -> entry.initOrInvalidateLastCache(database, deviceId.getTableName(), measurements, isInvalidate, true), !isInvalidate);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void updateLastCacheIfExists(String database, IDeviceID deviceId, String[] measurements, TimeValuePair[] timeValuePairs, boolean invalidateNull) {
        this.dualKeyCache.update(new TableId(database, deviceId.getTableName()), deviceId, null, entry -> entry.tryUpdateLastCache(measurements, timeValuePairs, invalidateNull), false);
    }

    public void updateLastCacheIfExists(String database, IDeviceID deviceId, String[] measurements, TimeValuePair[] timeValuePairs) {
        this.updateLastCacheIfExists(database, deviceId, measurements, timeValuePairs, false);
    }

    public TimeValuePair getLastEntry(@Nullable String database, IDeviceID deviceId, String measurement) {
        TableDeviceCacheEntry entry = this.dualKeyCache.get(new TableId(database, deviceId.getTableName()), deviceId);
        return Objects.nonNull(entry) ? entry.getTimeValuePair(measurement) : null;
    }

    public TimeValuePair[] getLastEntries(@Nullable String database, IDeviceID deviceId, String[] measurements) {
        TableDeviceCacheEntry entry = this.dualKeyCache.get(new TableId(database, deviceId.getTableName()), deviceId);
        return Objects.nonNull(entry) ? (TimeValuePair[])Arrays.stream(measurements).map(entry::getTimeValuePair).toArray(TimeValuePair[]::new) : null;
    }

    public Optional<Pair<OptionalLong, TsPrimitiveType[]>> getLastRow(String database, IDeviceID deviceId, String sourceMeasurement, List<String> targetMeasurements) {
        TableDeviceCacheEntry entry = this.dualKeyCache.get(new TableId(database, deviceId.getTableName()), deviceId);
        return Objects.nonNull(entry) ? entry.getLastRow(sourceMeasurement, targetMeasurements) : Optional.empty();
    }

    public void invalidateLastCache(String database, String table) {
        this.dualKeyCache.update(new TableId(database, table), deviceId -> true, entry -> -entry.invalidateLastCache());
    }

    public void invalidateLastCache(String database, IDeviceID deviceId) {
        this.dualKeyCache.update(new TableId(database, deviceId.getTableName()), deviceId, null, entry -> -entry.invalidateLastCache(), false);
    }

    public void putDeviceSchema(String database, DeviceSchemaInfo deviceSchemaInfo) {
        PartialPath devicePath = deviceSchemaInfo.getDevicePath();
        IDeviceID deviceID = devicePath.getIDeviceID();
        String previousDatabase = this.treeModelDatabasePool.putIfAbsent(database, database);
        this.dualKeyCache.update(new TableId(null, deviceID.getTableName()), deviceID, new TableDeviceCacheEntry(), entry -> entry.setDeviceSchema(Objects.nonNull(previousDatabase) ? previousDatabase : database, deviceSchemaInfo), true);
    }

    public IDeviceSchema getDeviceSchema(String[] devicePath) {
        return this.getDeviceSchema(IDeviceID.Factory.DEFAULT_FACTORY.create(StringArrayDeviceID.splitDeviceIdString((String[])devicePath)));
    }

    public IDeviceSchema getDeviceSchema(IDeviceID deviceID) {
        TableDeviceCacheEntry entry = this.dualKeyCache.get(new TableId(null, deviceID.getTableName()), deviceID);
        return Objects.nonNull(entry) ? entry.getDeviceSchema() : null;
    }

    void updateLastCache(String database, IDeviceID deviceID, String[] measurements, @Nullable TimeValuePair[] timeValuePairs, boolean isAligned, IMeasurementSchema[] measurementSchemas, boolean initOrInvalidate) {
        String previousDatabase = this.treeModelDatabasePool.putIfAbsent(database, database);
        String database2Use = Objects.nonNull(previousDatabase) ? previousDatabase : database;
        this.dualKeyCache.update(new TableId(null, deviceID.getTableName()), deviceID, new TableDeviceCacheEntry(), initOrInvalidate ? entry -> entry.setMeasurementSchema(database2Use, isAligned, measurements, measurementSchemas) + entry.initOrInvalidateLastCache(database, deviceID.getTableName(), measurements, Objects.nonNull(timeValuePairs), false) : entry -> entry.setMeasurementSchema(database2Use, isAligned, measurements, measurementSchemas) + entry.tryUpdateLastCache(measurements, timeValuePairs), Objects.isNull(timeValuePairs));
    }

    public boolean getLastCache(Map<TableId, Map<IDeviceID, Map<String, Pair<TSDataType, TimeValuePair>>>> inputMap) {
        return this.dualKeyCache.batchApply(inputMap, TableDeviceCacheEntry::updateInputMap);
    }

    void invalidateLastCache(PartialPath devicePath, String measurement) {
        ToIntFunction<TableDeviceCacheEntry> updateFunction;
        ToIntFunction<TableDeviceCacheEntry> toIntFunction = updateFunction = PathPatternUtil.hasWildcard((String)measurement) ? entry -> -entry.invalidateLastCache() : entry -> -entry.invalidateLastCache(measurement, false);
        if (!devicePath.hasWildcard()) {
            IDeviceID deviceID = devicePath.getIDeviceID();
            this.dualKeyCache.update(new TableId(null, deviceID.getTableName()), deviceID, null, updateFunction, false);
        } else {
            this.dualKeyCache.update(tableId -> {
                try {
                    return devicePath.matchPrefixPath(new PartialPath(tableId.getTableName()));
                }
                catch (IllegalPathException e) {
                    logger.warn("Illegal tableID {} found in cache when invalidating by path {}, invalidate it anyway", (Object)tableId.getTableName(), (Object)devicePath);
                    return true;
                }
            }, cachedDeviceID -> {
                try {
                    return new PartialPath(cachedDeviceID).matchFullPath(devicePath);
                }
                catch (IllegalPathException e) {
                    logger.warn("Illegal deviceID {} found in cache when invalidating by path {}, invalidate it anyway", cachedDeviceID, (Object)devicePath);
                    return true;
                }
            }, updateFunction);
        }
    }

    void invalidateCache(@Nonnull PartialPath devicePath, boolean isMultiLevelWildcardMeasurement) {
        if (!devicePath.hasWildcard()) {
            IDeviceID deviceID = devicePath.getIDeviceID();
            this.dualKeyCache.invalidate(new TableId(null, deviceID.getTableName()), deviceID);
        } else {
            this.dualKeyCache.invalidate((FK tableId) -> {
                try {
                    return devicePath.matchPrefixPath(new PartialPath(tableId.getTableName()));
                }
                catch (IllegalPathException e) {
                    logger.warn("Illegal tableID {} found in cache when invalidating by path {}, invalidate it anyway", (Object)tableId.getTableName(), (Object)devicePath);
                    return true;
                }
            }, (SK cachedDeviceID) -> {
                try {
                    return isMultiLevelWildcardMeasurement ? devicePath.matchPrefixPath(new PartialPath(cachedDeviceID)) : devicePath.matchFullPath(new PartialPath(cachedDeviceID));
                }
                catch (IllegalPathException e) {
                    logger.warn("Illegal deviceID {} found in cache when invalidating by path {}, invalidate it anyway", cachedDeviceID, (Object)devicePath);
                    return true;
                }
            });
        }
    }

    long getHitCount() {
        return this.dualKeyCache.stats().hitCount();
    }

    long getRequestCount() {
        return this.dualKeyCache.stats().requestCount();
    }

    long getMemoryUsage() {
        return this.dualKeyCache.stats().memoryUsage();
    }

    long capacity() {
        return this.dualKeyCache.stats().capacity();
    }

    long entriesCount() {
        return this.dualKeyCache.stats().entriesCount();
    }

    void invalidateLastCache(@Nonnull String database) {
        this.readWriteLock.writeLock().lock();
        try {
            if (PathUtils.isTableModelDatabase((String)database)) {
                this.dualKeyCache.update(tableId -> tableId.belongTo(database), deviceID -> true, entry -> -entry.invalidateLastCache());
            } else {
                this.dualKeyCache.update(tableId -> Objects.isNull(tableId.getDatabase()) && tableId.getTableName().startsWith(database), deviceID -> true, entry -> -entry.invalidateLastCache());
                this.dualKeyCache.update(tableId -> Objects.isNull(tableId.getDatabase()) && database.startsWith(tableId.getTableName()), deviceID -> deviceID.matchDatabaseName(database), entry -> -entry.invalidateLastCache());
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void invalidate(@Nonnull String database) {
        this.readWriteLock.writeLock().lock();
        try {
            if (PathUtils.isTableModelDatabase((String)database)) {
                this.dualKeyCache.invalidate((FK tableId) -> tableId.belongTo(database), (SK deviceID) -> true);
            } else {
                this.dualKeyCache.invalidate((FK tableId) -> Objects.isNull(tableId.getDatabase()) && tableId.getTableName().startsWith(database), (SK deviceID) -> true);
                this.dualKeyCache.invalidate((FK tableId) -> Objects.isNull(tableId.getDatabase()) && database.startsWith(tableId.getTableName()), (SK deviceID) -> deviceID.matchDatabaseName(database));
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void invalidate(String database, String tableName) {
        this.readWriteLock.writeLock().lock();
        try {
            DataNodeTableCache.getInstance().invalid(database, tableName);
            this.dualKeyCache.invalidate(new TableId(database, tableName));
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String database, String tableName, List<PartialPath> patterns) {
        this.readWriteLock.writeLock().lock();
        try {
            TableId firstKey = new TableId(database, tableName);
            if (patterns.isEmpty()) {
                this.dualKeyCache.invalidate(firstKey);
            } else {
                List multiMatchList = patterns.stream().filter(idFilter -> {
                    if (!idFilter.hasWildcard()) {
                        IDeviceID deviceId = IDeviceID.Factory.DEFAULT_FACTORY.create(Arrays.copyOfRange(idFilter.getNodes(), 2, idFilter.getNodeLength()));
                        this.dualKeyCache.invalidate(firstKey, deviceId);
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
                this.dualKeyCache.invalidate(firstKey, (SK deviceId) -> {
                    String[] segments = (String[])deviceId.getSegments();
                    for (int i = 1; i < segments.length; ++i) {
                        for (PartialPath path : multiMatchList) {
                            int pathIndex = i + 2;
                            if (!path.getNodes()[pathIndex].equals(segments[i]) && (!path.getNodes()[pathIndex].equals("*") || !((ExtendedPartialPath)path).match(pathIndex, segments[i]))) continue;
                            return true;
                        }
                    }
                    return false;
                });
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String database, String tableName, String columnName, boolean isAttributeColumn) {
        this.readWriteLock.writeLock().lock();
        try {
            DataNodeTableCache.getInstance().invalid(database, tableName, columnName);
            ToIntFunction<TableDeviceCacheEntry> updateFunction = isAttributeColumn ? entry -> -entry.invalidateAttributeColumn(columnName) : entry -> -entry.invalidateLastCache(columnName, true);
            this.dualKeyCache.update(new TableId(null, tableName), deviceID -> true, updateFunction);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void invalidateLastCache() {
        this.readWriteLock.writeLock().lock();
        try {
            this.dualKeyCache.update(tableId -> true, deviceID -> true, entry -> -entry.invalidateLastCache());
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void invalidateAttributeCache() {
        this.readWriteLock.writeLock().lock();
        try {
            this.dualKeyCache.update(tableId -> true, deviceID -> true, entry -> -entry.invalidateAttribute());
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void invalidateTreeSchema() {
        this.readWriteLock.writeLock().lock();
        try {
            this.dualKeyCache.update(tableId -> true, deviceID -> true, entry -> -entry.invalidateTreeSchema());
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void invalidateAll() {
        this.readWriteLock.writeLock().lock();
        try {
            this.dualKeyCache.invalidateAll();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private static class TableDeviceSchemaCacheHolder {
        private static final TableDeviceSchemaCache INSTANCE = new TableDeviceSchemaCache();

        private TableDeviceSchemaCacheHolder() {
        }
    }
}

