/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;

public class InPredicate
extends Expression {
    private final Expression value;
    private final Expression valueList;

    public InPredicate(Expression value, Expression valueList) {
        super(null);
        this.value = Objects.requireNonNull(value, "value is null");
        this.valueList = Objects.requireNonNull(valueList, "valueList is null");
    }

    public InPredicate(NodeLocation location, Expression value, Expression valueList) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Objects.requireNonNull(value, "value is null");
        this.valueList = Objects.requireNonNull(valueList, "valueList is null");
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getValueList() {
        return this.valueList;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInPredicate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.value, (Object)this.valueList);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InPredicate that = (InPredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.valueList, that.valueList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.valueList);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return InPredicate.sameClass(this, other);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.IN_PREDICATE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.value, stream);
        Expression.serialize(this.valueList, stream);
    }

    public InPredicate(ByteBuffer byteBuffer) {
        super(null);
        this.value = Expression.deserialize(byteBuffer);
        this.valueList = Expression.deserialize(byteBuffer);
    }
}

