/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class AlterPipeStatement
extends Statement
implements IConfigStatement {
    private String pipeName;
    private String userName;
    private boolean ifExistsCondition;
    private Map<String, String> extractorAttributes;
    private Map<String, String> processorAttributes;
    private Map<String, String> connectorAttributes;
    private boolean isReplaceAllExtractorAttributes;
    private boolean isReplaceAllProcessorAttributes;
    private boolean isReplaceAllConnectorAttributes;
    private boolean isTableModel;

    public AlterPipeStatement(StatementType alterPipeStatement) {
        this.statementType = alterPipeStatement;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public boolean hasIfExistsCondition() {
        return this.ifExistsCondition;
    }

    public Map<String, String> getExtractorAttributes() {
        return this.extractorAttributes;
    }

    public Map<String, String> getProcessorAttributes() {
        return this.processorAttributes;
    }

    public Map<String, String> getConnectorAttributes() {
        return this.connectorAttributes;
    }

    public boolean isReplaceAllExtractorAttributes() {
        return this.isReplaceAllExtractorAttributes;
    }

    public boolean isReplaceAllProcessorAttributes() {
        return this.isReplaceAllProcessorAttributes;
    }

    public boolean isReplaceAllConnectorAttributes() {
        return this.isReplaceAllConnectorAttributes;
    }

    public boolean isTableModel() {
        return this.isTableModel;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public void setIfExists(boolean ifExistsCondition) {
        this.ifExistsCondition = ifExistsCondition;
    }

    public void setExtractorAttributes(Map<String, String> extractorAttributes) {
        this.extractorAttributes = extractorAttributes;
    }

    public void setProcessorAttributes(Map<String, String> processorAttributes) {
        this.processorAttributes = processorAttributes;
    }

    public void setConnectorAttributes(Map<String, String> connectorAttributes) {
        this.connectorAttributes = connectorAttributes;
    }

    public void setReplaceAllExtractorAttributes(boolean replaceAllExtractorAttributes) {
        this.isReplaceAllExtractorAttributes = replaceAllExtractorAttributes;
    }

    public void setReplaceAllProcessorAttributes(boolean replaceAllProcessorAttributes) {
        this.isReplaceAllProcessorAttributes = replaceAllProcessorAttributes;
    }

    public void setReplaceAllConnectorAttributes(boolean replaceAllConnectorAttributes) {
        this.isReplaceAllConnectorAttributes = replaceAllConnectorAttributes;
    }

    public void setTableModel(boolean tableModel) {
        this.isTableModel = tableModel;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.USE_PIPE), PrivilegeType.USE_PIPE);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitAlterPipe(this, context);
    }
}

