/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.utils.validate;

import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.storageengine.dataregion.utils.validate.TsFileValidator;

public class TsFileResourceAndDataValidator
implements TsFileValidator {
    @Override
    public boolean validateTsFile(TsFileResource resource) {
        return TsFileResourceUtils.validateTsFileResourceCorrectness(resource) && TsFileResourceUtils.validateTsFileDataCorrectness(resource);
    }

    @Override
    public boolean validateTsFiles(List<TsFileResource> resourceList) {
        for (TsFileResource resource : resourceList) {
            if (this.validateTsFile(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validateTsFilesIsHasNoOverlap(List<TsFileResource> resourceList) {
        return TsFileResourceUtils.validateTsFileResourcesHasNoOverlap(resourceList);
    }

    public static TsFileResourceAndDataValidator getInstance() {
        return TsFileDataCorrectnessValidatorHolder.INSTANCE;
    }

    private static class TsFileDataCorrectnessValidatorHolder {
        private static final TsFileResourceAndDataValidator INSTANCE = new TsFileResourceAndDataValidator();

        private TsFileDataCorrectnessValidatorHolder() {
        }
    }
}

