/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imapserver.netty.IMAPServer;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.lib.netty.AbstractServerFactory;

public class IMAPServerFactory
extends AbstractServerFactory {
    protected final FileSystem fileSystem;
    protected final Provider<ImapDecoder> decoder;
    protected final Provider<ImapEncoder> encoder;
    protected final Provider<ImapProcessor> processor;
    protected final ImapMetrics imapMetrics;
    protected final GaugeRegistry gaugeRegistry;

    @Inject
    @Deprecated
    public IMAPServerFactory(FileSystem fileSystem, ImapDecoder decoder, ImapEncoder encoder, ImapProcessor processor, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        this.fileSystem = fileSystem;
        this.decoder = () -> decoder;
        this.encoder = () -> encoder;
        this.processor = () -> processor;
        this.imapMetrics = new ImapMetrics(metricFactory);
        this.gaugeRegistry = gaugeRegistry;
    }

    public IMAPServerFactory(FileSystem fileSystem, Provider<ImapDecoder> decoder, Provider<ImapEncoder> encoder, Provider<ImapProcessor> processor, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        this.fileSystem = fileSystem;
        this.decoder = decoder;
        this.encoder = encoder;
        this.processor = processor;
        this.imapMetrics = new ImapMetrics(metricFactory);
        this.gaugeRegistry = gaugeRegistry;
    }

    protected IMAPServer createServer() {
        return new IMAPServer((ImapDecoder)this.decoder.get(), (ImapEncoder)this.encoder.get(), (ImapProcessor)this.processor.get(), this.imapMetrics, this.gaugeRegistry);
    }

    protected List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration<ImmutableNode> config) throws Exception {
        ArrayList<AbstractConfigurableAsyncServer> servers = new ArrayList<AbstractConfigurableAsyncServer>();
        List configs = config.configurationsAt("imapserver");
        for (HierarchicalConfiguration serverConfig : configs) {
            IMAPServer server = this.createServer();
            server.setFileSystem(this.fileSystem);
            server.configure(serverConfig);
            servers.add(server);
        }
        return servers;
    }
}

