/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.futurerelease;

import com.google.common.collect.ImmutableSet;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.futurerelease.FutureReleaseParameters;

public class FutureReleaseEHLOHook
implements HeloHook {
    private final Clock clock;

    @Inject
    public FutureReleaseEHLOHook(Clock clock) {
        this.clock = clock;
    }

    public Set<String> implementedEsmtpFeatures(SMTPSession session) {
        if (session.getUsername() != null) {
            Instant now = LocalDateTime.now(this.clock).toInstant(ZoneOffset.UTC);
            String dateAsString = DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.of("UTC")).format(now.plus(FutureReleaseParameters.MAX_HOLD_FOR_SUPPORTED));
            return ImmutableSet.of((Object)("FUTURERELEASE " + FutureReleaseParameters.MAX_HOLD_FOR_SUPPORTED.toSeconds() + " " + dateAsString));
        }
        return ImmutableSet.of();
    }

    public HookResult doHelo(SMTPSession session, String helo) {
        return HookResult.DECLINED;
    }
}

