/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.UUID;
import org.apache.james.mailbox.model.AttachmentId;

public class UuidBackedAttachmentId
implements AttachmentId {
    private final UUID id;

    public static UuidBackedAttachmentId random() {
        return new UuidBackedAttachmentId(UUID.randomUUID());
    }

    public static UuidBackedAttachmentId from(String id) {
        return new UuidBackedAttachmentId(UUID.fromString(id));
    }

    public static UuidBackedAttachmentId from(UUID id) {
        return new UuidBackedAttachmentId(id);
    }

    private UuidBackedAttachmentId(UUID id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id.toString();
    }

    @Override
    public UUID asUUID() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UuidBackedAttachmentId) {
            UuidBackedAttachmentId other = (UuidBackedAttachmentId)obj;
            return Objects.equal((Object)this.id, (Object)other.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }
}

