/*
 * Decompiled with CFR 0.152.
 */
package spark.embeddedserver.jetty;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.embeddedserver.EmbeddedServer;
import spark.embeddedserver.VirtualThreadAware;
import spark.embeddedserver.jetty.JettyServerFactory;
import spark.embeddedserver.jetty.SocketConnectorFactory;
import spark.embeddedserver.jetty.websocket.WebSocketHandlerWrapper;
import spark.embeddedserver.jetty.websocket.WebSocketServletContextHandlerFactory;
import spark.http.matching.MatcherFilter;
import spark.ssl.SslStores;

public class EmbeddedJettyServer
extends VirtualThreadAware.Proxy
implements EmbeddedServer {
    private static final int SPARK_DEFAULT_PORT = 4567;
    private static final String NAME = "Spark";
    private final JettyServerFactory serverFactory;
    private final boolean httpOnly;
    private final MatcherFilter matcherFilter;
    private Server server;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, WebSocketHandlerWrapper> webSocketHandlers;
    private Optional<Long> webSocketIdleTimeoutMillis;
    private ThreadPool threadPool = null;
    private boolean trustForwardHeaders = true;

    public EmbeddedJettyServer(JettyServerFactory serverFactory, boolean httpOnly, MatcherFilter matcherFilter) {
        super(serverFactory);
        this.serverFactory = serverFactory;
        this.httpOnly = httpOnly;
        this.matcherFilter = matcherFilter;
    }

    @Override
    public void configureWebSockets(Map<String, WebSocketHandlerWrapper> webSocketHandlers, Optional<Long> webSocketIdleTimeoutMillis) {
        this.webSocketHandlers = webSocketHandlers;
        this.webSocketIdleTimeoutMillis = webSocketIdleTimeoutMillis;
    }

    @Override
    public void trustForwardHeaders(boolean trust) {
        this.trustForwardHeaders = trust;
    }

    @Override
    public int ignite(String host, int port, boolean useHTTP2, SslStores sslStores, int maxThreads, int minThreads, int threadIdleTimeoutMillis) throws Exception {
        boolean hasCustomizedConnectors = false;
        if (port == 0) {
            try (ServerSocket s = new ServerSocket(0);){
                port = s.getLocalPort();
            }
            catch (IOException e) {
                this.logger.error("Could not get first available port (port set to 0), using default: {}", (Object)4567);
                port = 4567;
            }
        }
        this.server = this.threadPool == null ? this.serverFactory.create(maxThreads, minThreads, threadIdleTimeoutMillis) : this.serverFactory.create(this.threadPool);
        ServerConnector connector = sslStores == null ? SocketConnectorFactory.createSocketConnector(this.server, host, port, useHTTP2, this.trustForwardHeaders) : SocketConnectorFactory.createSecureSocketConnector(this.server, host, port, sslStores, useHTTP2, this.trustForwardHeaders);
        Connector[] previousConnectors = this.server.getConnectors();
        this.server = connector.getServer();
        if (previousConnectors.length != 0) {
            this.server.setConnectors(previousConnectors);
            hasCustomizedConnectors = true;
        } else {
            this.server.setConnectors(new Connector[]{connector});
        }
        ServletContextHandler webSocketServletContextHandler = WebSocketServletContextHandlerFactory.create(this.webSocketHandlers, this.webSocketIdleTimeoutMillis);
        ServletContextHandler servletContextHandler = webSocketServletContextHandler == null ? new ServletContextHandler() : webSocketServletContextHandler;
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.getSessionCookieConfig().setHttpOnly(this.httpOnly);
        servletContextHandler.setSessionHandler(sessionHandler);
        servletContextHandler.addFilter((Filter)this.matcherFilter, "/*", EnumSet.allOf(DispatcherType.class));
        this.server.setHandler((Handler)servletContextHandler);
        this.logger.info("== {} has ignited ...", (Object)NAME);
        if (hasCustomizedConnectors) {
            this.logger.info(">> Listening on Custom Server ports!");
        } else {
            this.logger.info(">> Listening on {}:{}", (Object)host, (Object)port);
        }
        this.server.start();
        return port;
    }

    @Override
    public void join() throws InterruptedException {
        this.server.join();
    }

    @Override
    public void extinguish() {
        this.logger.info(">>> {} shutting down ...", (Object)NAME);
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            this.logger.error("stop failed", (Throwable)e);
            System.exit(100);
        }
        this.logger.info("done");
    }

    @Override
    public int activeThreadCount() {
        if (this.server == null) {
            return 0;
        }
        return this.server.getThreadPool().getThreads() - this.server.getThreadPool().getIdleThreads();
    }

    public EmbeddedJettyServer withThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
        return this;
    }
}

