/*
 * Decompiled with CFR 0.152.
 */
package spark.embeddedserver.jetty.websocket;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.embeddedserver.jetty.websocket.WebSocketCreatorFactory;
import spark.embeddedserver.jetty.websocket.WebSocketHandlerWrapper;

public class WebSocketServletContextHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServletContextHandlerFactory.class);

    public static ServletContextHandler create(Map<String, WebSocketHandlerWrapper> webSocketHandlers, Optional<Long> webSocketIdleTimeoutMillis) {
        if (webSocketHandlers == null) {
            return null;
        }
        try {
            ServletContextHandler webSocketServletContextHandler = new ServletContextHandler();
            JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)webSocketServletContextHandler, (servletContext, wsContainer) -> {
                if (webSocketIdleTimeoutMillis.isPresent()) {
                    long to = (Long)webSocketIdleTimeoutMillis.get();
                    wsContainer.setIdleTimeout(Duration.ofMillis(to));
                }
                for (String path : webSocketHandlers.keySet()) {
                    JettyWebSocketCreator webSocketCreator = WebSocketCreatorFactory.createWS((WebSocketHandlerWrapper)webSocketHandlers.get(path));
                    wsContainer.addMapping(path, webSocketCreator);
                }
            });
            return webSocketServletContextHandler;
        }
        catch (Exception ex) {
            logger.error("creation of websocket context handler failed.", (Throwable)ex);
            return null;
        }
    }
}

