/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;

public class ListenerConfiguration {
    private final String clazz;
    private final Optional<String> group;
    private final Optional<HierarchicalConfiguration<ImmutableNode>> configuration;
    private final Optional<Boolean> isAsync;

    public static ListenerConfiguration from(HierarchicalConfiguration<ImmutableNode> configuration) {
        String listenerClass = configuration.getString("class");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)listenerClass) ? 1 : 0) != 0, (Object)"class name is mandatory");
        Optional<Boolean> isAsync = Optional.ofNullable(configuration.getBoolean("async", null));
        Optional<String> group = Optional.ofNullable(configuration.getString("group", null));
        return new ListenerConfiguration(listenerClass, group, ListenerConfiguration.extractSubconfiguration(configuration), isAsync);
    }

    public static ListenerConfiguration forClass(String clazz) {
        return new ListenerConfiguration(clazz, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static Optional<HierarchicalConfiguration<ImmutableNode>> extractSubconfiguration(HierarchicalConfiguration<ImmutableNode> configuration) {
        return configuration.configurationsAt("configuration").stream().findFirst();
    }

    private ListenerConfiguration(String clazz, Optional<String> group, Optional<HierarchicalConfiguration<ImmutableNode>> configuration, Optional<Boolean> isAsync) {
        this.clazz = clazz;
        this.group = group;
        this.configuration = configuration;
        this.isAsync = isAsync;
    }

    public Optional<String> getGroup() {
        return this.group;
    }

    public String getClazz() {
        return this.clazz;
    }

    public Optional<HierarchicalConfiguration<ImmutableNode>> getConfiguration() {
        return this.configuration;
    }

    public Optional<Boolean> isAsync() {
        return this.isAsync;
    }
}

