/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReaderChangeRecordTranslator;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AggregateLDIFReaderChangeRecordTranslator
implements LDIFReaderChangeRecordTranslator {
    @NotNull
    private final List<LDIFReaderChangeRecordTranslator> translators;

    public AggregateLDIFReaderChangeRecordTranslator(LDIFReaderChangeRecordTranslator ... translators) {
        this(StaticUtils.toList(translators));
    }

    public AggregateLDIFReaderChangeRecordTranslator(@Nullable Collection<? extends LDIFReaderChangeRecordTranslator> translators) {
        this.translators = translators == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<LDIFReaderChangeRecordTranslator>(translators));
    }

    @Override
    @Nullable
    public LDIFChangeRecord translate(@NotNull LDIFChangeRecord original, long firstLineNumber) throws LDIFException {
        if (original == null) {
            return null;
        }
        LDIFChangeRecord r = original;
        for (LDIFReaderChangeRecordTranslator t : this.translators) {
            r = t.translate(r, firstLineNumber);
            if (r != null) continue;
            return null;
        }
        return r;
    }
}

