/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PassphraseEncryptedStreamHeaderCachedKeyIdentifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;

final class PassphraseEncryptedStreamHeaderSecretKeyCache {
    private static final int MAX_CACHE_COUNT = 10000;
    @NotNull
    private static final Map<PassphraseEncryptedStreamHeaderCachedKeyIdentifier, SecretKey> KEY_MAP = new ConcurrentHashMap<PassphraseEncryptedStreamHeaderCachedKeyIdentifier, SecretKey>();

    private PassphraseEncryptedStreamHeaderSecretKeyCache() {
    }

    @Nullable
    static SecretKey get(@NotNull PassphraseEncryptedStreamHeaderCachedKeyIdentifier id) {
        return KEY_MAP.get(id);
    }

    static void put(@NotNull PassphraseEncryptedStreamHeaderCachedKeyIdentifier id, @NotNull SecretKey secretKey) {
        KEY_MAP.put(id, secretKey);
        if (KEY_MAP.size() > 10000) {
            KEY_MAP.clear();
            KEY_MAP.put(id, secretKey);
        }
    }

    @Nullable
    static SecretKey remove(@NotNull PassphraseEncryptedStreamHeaderCachedKeyIdentifier id) {
        return KEY_MAP.remove(id);
    }

    static void clear() {
        KEY_MAP.clear();
    }

    static int size() {
        return KEY_MAP.size();
    }
}

