/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.io.CountingInputStream;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.Upload;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.model.UploadNotFoundException;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.cassandra.upload.UploadDAO;
import org.apache.james.mailbox.model.ContentType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraUploadRepository
implements UploadRepository {
    public static final BucketName UPLOAD_BUCKET = BucketName.of((String)"jmap-uploads");
    private final UploadDAO uploadDAO;
    private final BlobId.Factory blobIdFactory;
    private final BlobStoreDAO blobStoreDAO;
    private final Clock clock;

    @Inject
    public CassandraUploadRepository(UploadDAO uploadDAO, BlobId.Factory blobIdFactory, BlobStoreDAO blobStoreDAO, Clock clock) {
        this.uploadDAO = uploadDAO;
        this.blobIdFactory = blobIdFactory;
        this.blobStoreDAO = blobStoreDAO;
        this.clock = clock;
    }

    public Mono<UploadMetaData> upload(InputStream data, ContentType contentType, Username user) {
        UploadId uploadId = this.generateId();
        BlobId blobId = this.blobIdFactory.of(uploadId.asString());
        return Mono.fromCallable(() -> new CountingInputStream(data)).flatMap(countingInputStream -> Mono.from((Publisher)this.blobStoreDAO.save(UPLOAD_BUCKET, blobId, (InputStream)countingInputStream)).thenReturn(countingInputStream)).map(countingInputStream -> new UploadDAO.UploadRepresentation(uploadId, blobId, contentType, countingInputStream.getCount(), user, this.clock.instant().truncatedTo(ChronoUnit.MILLIS))).flatMap(upload -> this.uploadDAO.save((UploadDAO.UploadRepresentation)upload).thenReturn((Object)upload.toUploadMetaData()));
    }

    public Mono<Upload> retrieve(UploadId id, Username user) {
        return this.uploadDAO.retrieve(user, id).flatMap(upload -> Mono.from((Publisher)this.blobStoreDAO.readReactive(UPLOAD_BUCKET, upload.getBlobId())).map(inputStream -> Upload.from((UploadMetaData)upload.toUploadMetaData(), () -> inputStream))).switchIfEmpty(Mono.error(() -> new UploadNotFoundException(id)));
    }

    public Mono<Boolean> delete(UploadId id, Username user) {
        return this.uploadDAO.delete(user, id);
    }

    public Flux<UploadMetaData> listUploads(Username user) {
        return this.uploadDAO.list(user).map(UploadDAO.UploadRepresentation::toUploadMetaData);
    }

    public Mono<Void> deleteByUploadDateBefore(Duration expireDuration) {
        Instant expirationTime = this.clock.instant().minus(expireDuration);
        return Flux.from(this.uploadDAO.all()).filter(upload -> upload.getUploadDate().isBefore(expirationTime)).flatMap(upload -> Mono.from((Publisher)this.blobStoreDAO.delete(UPLOAD_BUCKET, upload.getBlobId())).then(this.uploadDAO.delete(upload.getUser(), upload.getId())), 16).then();
    }

    private UploadId generateId() {
        return UploadId.from((UUID)Uuids.timeBased());
    }
}

