/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.altindag.ssl.util.KeyStoreUtils;
import nl.altindag.ssl.util.OSCertificateUtils;
import nl.altindag.ssl.util.internal.CollectorsUtils;

final class LinuxCertificateUtils
extends OSCertificateUtils {
    private static LinuxCertificateUtils INSTANCE;
    private static final String HOME_DIRECTORY;
    private static final List<Path> LINUX_CERTIFICATE_PATHS;

    private LinuxCertificateUtils() {
    }

    @Override
    List<KeyStore> getTrustStores() {
        List<Certificate> certificates = this.getCertificates();
        if (!certificates.isEmpty()) {
            KeyStore linuxTrustStore = KeyStoreUtils.createTrustStore(certificates);
            return Collections.singletonList(linuxTrustStore);
        }
        return Collections.emptyList();
    }

    List<Certificate> getCertificates() {
        return this.getCertificates(LINUX_CERTIFICATE_PATHS).stream().distinct().collect(CollectorsUtils.toUnmodifiableList());
    }

    static LinuxCertificateUtils getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LinuxCertificateUtils();
        }
        return INSTANCE;
    }

    static {
        HOME_DIRECTORY = System.getProperty("user.home");
        LINUX_CERTIFICATE_PATHS = Stream.of("/etc/ssl/certs", "/etc/pki/nssdb", "/usr/local/share/ca-certificates", "/usr/share/ca-certificates", "/etc/pki/tls/certs/ca-bundle.crt", "/etc/pki/ca-trust/source/anchors", "/etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem", HOME_DIRECTORY + "/.pki/nssdb").map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }
}

