/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.process.StreamRDFApply;
import org.apache.jena.riot.process.normalize.NormalizeRDFTerms;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdInline;

public class NormalizeTermsTDB2 {
    public static Node normalizeTDB2(Node node) {
        NodeId x = NodeIdInline.inline(node);
        if (x == null) {
            return NormalizeRDFTerms.get().normalize(node);
        }
        Node inlined = NodeIdInline.extract(x);
        return inlined;
    }

    public static StreamRDF stream(StreamRDF base) {
        return new StreamNormalizedTDB2(base);
    }

    static class StreamNormalizedTDB2
    extends StreamRDFApply {
        public StreamNormalizedTDB2(StreamRDF other) {
            super(other, NormalizeTermsTDB2::normalizeTDB2, NormalizeTermsTDB2::normalizeTDB2, NormalizeTermsTDB2::normalizeTDB2, NormalizeTermsTDB2::normalizeTDB2);
        }
    }
}

