/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.directory.api.ldap.aci.ACITuple;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.aci.protectedItem.AllAttributeValuesItem;
import org.apache.directory.api.ldap.aci.protectedItem.AttributeTypeItem;
import org.apache.directory.api.ldap.aci.protectedItem.AttributeValueItem;
import org.apache.directory.api.ldap.aci.protectedItem.RangeOfValuesItem;
import org.apache.directory.api.ldap.aci.protectedItem.SelfValueItem;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;

public class MostSpecificProtectedItemFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        if (aciContext.getAciTuples().size() <= 1) {
            return aciContext.getAciTuples();
        }
        ArrayList<ACITuple> filteredTuples = new ArrayList<ACITuple>();
        block0: for (ACITuple tuple : aciContext.getAciTuples()) {
            for (ProtectedItem item : tuple.getProtectedItems()) {
                if (!(item instanceof AttributeTypeItem) && !(item instanceof AllAttributeValuesItem) && !(item instanceof SelfValueItem) && !(item instanceof AttributeValueItem)) continue;
                filteredTuples.add(tuple);
                continue block0;
            }
        }
        if (!filteredTuples.isEmpty()) {
            return filteredTuples;
        }
        for (ACITuple tuple : aciContext.getAciTuples()) {
            for (ProtectedItem item : tuple.getProtectedItems()) {
                if (!(item instanceof RangeOfValuesItem)) continue;
                filteredTuples.add(tuple);
            }
        }
        if (!filteredTuples.isEmpty()) {
            return filteredTuples;
        }
        return aciContext.getAciTuples();
    }
}

