/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteStepDescriptor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;

public abstract class UrlRewriteStepProcessorFactory {
    private static final Map<Class<? extends UrlRewriteStepDescriptor>, Map<String, Class<? extends UrlRewriteStepProcessor>>> MAP = UrlRewriteStepProcessorFactory.loadStepProcessors();

    private UrlRewriteStepProcessorFactory() {
    }

    public static UrlRewriteStepProcessor create(UrlRewriteStepDescriptor descriptor) throws IllegalAccessException, InstantiationException {
        Map<String, Class<? extends UrlRewriteStepProcessor>> typeMap = MAP.get(descriptor.getClass());
        if (typeMap == null) {
            Class<? extends UrlRewriteStepDescriptor> descriptorInterface = UrlRewriteStepProcessorFactory.getDescriptorInterface(descriptor);
            typeMap = MAP.get(descriptorInterface);
        }
        if (typeMap == null) {
            throw new IllegalArgumentException(descriptor.getClass().getName());
        }
        String type = descriptor.type();
        Class<? extends UrlRewriteStepProcessor> processorClass = typeMap.get(type);
        if (processorClass == null) {
            throw new IllegalArgumentException(type);
        }
        UrlRewriteStepProcessor processor = processorClass.newInstance();
        return processor;
    }

    private static Map<Class<? extends UrlRewriteStepDescriptor>, Map<String, Class<? extends UrlRewriteStepProcessor>>> loadStepProcessors() {
        HashMap<Class<? extends UrlRewriteStepDescriptor>, Map<String, Class<? extends UrlRewriteStepProcessor>>> descriptorMap = new HashMap<Class<? extends UrlRewriteStepDescriptor>, Map<String, Class<? extends UrlRewriteStepProcessor>>>();
        ServiceLoader<UrlRewriteStepProcessor> processors = ServiceLoader.load(UrlRewriteStepProcessor.class);
        for (UrlRewriteStepProcessor processor : processors) {
            Class<? extends UrlRewriteStepDescriptor> descriptorInterface = UrlRewriteStepProcessorFactory.getDescriptorInterface(processor);
            Map typeMap = descriptorMap.computeIfAbsent(descriptorInterface, k -> new HashMap());
            String processorType = processor.getType();
            typeMap.put(processorType, processor.getClass());
        }
        return descriptorMap;
    }

    private static Class<? extends UrlRewriteStepDescriptor> getDescriptorInterface(UrlRewriteStepDescriptor descriptor) {
        Class<? extends UrlRewriteStepDescriptor> descriptorClass = null;
        for (Type interfaceType : descriptor.getClass().getGenericInterfaces()) {
            Class genericClass = (Class)interfaceType;
            if (!UrlRewriteStepDescriptor.class.isAssignableFrom(genericClass)) continue;
            descriptorClass = UrlRewriteStepProcessorFactory.uncheckedStepDescriptorClassCast(genericClass);
            break;
        }
        return descriptorClass;
    }

    private static Class<? extends UrlRewriteStepDescriptor> getDescriptorInterface(UrlRewriteStepProcessor processor) {
        Class<? extends UrlRewriteStepDescriptor> descriptorClass = null;
        Class<?> processorClass = processor.getClass();
        for (Type interfaceType : processorClass.getGenericInterfaces()) {
            if (!UrlRewriteStepProcessor.class.isAssignableFrom((Class)((ParameterizedType)interfaceType).getRawType())) continue;
            ParameterizedType interfaceClass = (ParameterizedType)interfaceType;
            descriptorClass = UrlRewriteStepProcessorFactory.uncheckedStepDescriptorClassCast(interfaceClass.getActualTypeArguments()[0]);
            break;
        }
        return descriptorClass;
    }

    private static Class<? extends UrlRewriteStepDescriptor> uncheckedStepDescriptorClassCast(Type type) {
        return (Class)type;
    }
}

