/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;

class DistinctNode
extends SingleChildResultSetNode {
    boolean inSortedOrder;

    DistinctNode(ResultSetNode resultSetNode, boolean bl, Properties properties, ContextManager contextManager) throws StandardException {
        super(resultSetNode, properties, contextManager);
        ResultColumnList resultColumnList = this.childResult.getResultColumns().copyListAndObjects();
        this.setResultColumns(this.childResult.getResultColumns());
        this.childResult.setResultColumns(resultColumnList);
        this.getResultColumns().genVirtualColumnNodes(this, resultColumnList);
        this.getResultColumns().verifyAllOrderable();
        this.inSortedOrder = bl;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, optimizablePredicateList, costEstimate, rowOrdering);
        return super.optimizeIt(optimizer, optimizablePredicateList, costEstimate, rowOrdering);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        CostEstimate costEstimate2 = ((Optimizable)((Object)this.childResult)).estimateCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizer, rowOrdering);
        this.setCostEstimate(this.getCostEstimate(optimizer));
        this.getCostEstimate().setCost(costEstimate2.getEstimatedCost(), costEstimate2.rowCount(), costEstimate2.singleScanRowCount());
        return this.getCostEstimate();
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return false;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, predicateList, d);
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl, List<FromBaseTable> list) {
        return false;
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        int n = activationClassBuilder.addItem(activationClassBuilder.getColumnOrdering(this.getResultColumns()));
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(true);
        methodBuilder.push(this.inSortedOrder);
        methodBuilder.push(n);
        methodBuilder.push(activationClassBuilder.addItem(this.getResultColumns().buildRowTemplate()));
        methodBuilder.push(this.getResultColumns().getTotalColumnSize());
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getSortResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 9);
    }
}

