/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix.linux;

import com.pty4j.unix.PtyHelpers;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import jtermios.JTermios;

public class OSFacadeImpl
implements PtyHelpers.OSFacade {
    private static final C_lib m_Clib = (C_lib)Native.loadLibrary((String)"c", C_lib.class);
    private static final Linux_Util_lib m_Utillib = (Linux_Util_lib)Native.loadLibrary((String)"util", Linux_Util_lib.class);

    public OSFacadeImpl() {
        PtyHelpers.ONLCR = 4;
        PtyHelpers.VINTR = 0;
        PtyHelpers.VQUIT = 1;
        PtyHelpers.VERASE = 2;
        PtyHelpers.VKILL = 3;
        PtyHelpers.VSUSP = 10;
        PtyHelpers.VREPRINT = 12;
        PtyHelpers.VWERASE = 14;
        PtyHelpers.ECHOKE = 1;
        PtyHelpers.ECHOCTL = 64;
    }

    @Override
    public int kill(int pid, int signal) {
        return m_Clib.kill(pid, signal);
    }

    @Override
    public int waitpid(int pid, int[] stat, int options) {
        return m_Clib.waitpid(pid, stat, options);
    }

    @Override
    public int sigprocmask(int how, IntByReference set, IntByReference oldset) {
        return m_Clib.sigprocmask(how, set, oldset);
    }

    @Override
    public String strerror(int errno) {
        return m_Clib.strerror(errno);
    }

    @Override
    public int getpt() {
        return JTermios.open((String)"/dev/ptmx", (int)(JTermios.O_RDWR | JTermios.O_NOCTTY));
    }

    @Override
    public int grantpt(int fd) {
        return m_Clib.grantpt(fd);
    }

    @Override
    public int unlockpt(int fd) {
        return m_Clib.unlockpt(fd);
    }

    @Override
    public int close(int fd) {
        return m_Clib.close(fd);
    }

    @Override
    public String ptsname(int fd) {
        return m_Clib.ptsname(fd);
    }

    @Override
    public int killpg(int pid, int sig) {
        return m_Clib.killpg(pid, sig);
    }

    @Override
    public int fork() {
        return m_Clib.fork();
    }

    @Override
    public int pipe(int[] pipe2) {
        return JTermios.pipe((int[])pipe2);
    }

    @Override
    public int setsid() {
        return m_Clib.setsid();
    }

    @Override
    public int getpid() {
        return m_Clib.getpid();
    }

    @Override
    public int setpgid(int pid, int pgid) {
        return m_Clib.setpgid(pid, pgid);
    }

    @Override
    public void dup2(int fds, int fileno) {
        m_Clib.dup2(fds, fileno);
    }

    @Override
    public int getppid() {
        return m_Clib.getppid();
    }

    @Override
    public void unsetenv(String s) {
        m_Clib.unsetenv(s);
    }

    @Override
    public int login_tty(int fd) {
        return m_Utillib.login_tty(fd);
    }

    @Override
    public void chdir(String dirpath) {
        m_Clib.chdir(dirpath);
    }

    public static interface Linux_Util_lib
    extends Library {
        public int login_tty(int var1);
    }

    private static interface C_lib
    extends Library {
        public int kill(int var1, int var2);

        public int waitpid(int var1, int[] var2, int var3);

        public int sigprocmask(int var1, IntByReference var2, IntByReference var3);

        public String strerror(int var1);

        public int grantpt(int var1);

        public int unlockpt(int var1);

        public int close(int var1);

        public String ptsname(int var1);

        public int open(String var1, int var2);

        public int killpg(int var1, int var2);

        public int fork();

        public int setsid();

        public int getpid();

        public int setpgid(int var1, int var2);

        public void dup2(int var1, int var2);

        public int getppid();

        public void unsetenv(String var1);

        public void chdir(String var1);
    }
}

