/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapPrincipalSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(LdapPrincipalSerializer.class);

    private LdapPrincipalSerializer() {
    }

    public static void serialize(LdapPrincipal principal, ObjectOutput out) throws IOException {
        out.writeInt(principal.getAuthenticationLevel().getLevel());
        if (principal.getDn() == null) {
            Dn.EMPTY_DN.writeExternal(out);
        } else {
            principal.getDn().writeExternal(out);
        }
    }

    public static LdapPrincipal deserialize(SchemaManager schemaManager, ObjectInput in) throws IOException {
        AuthenticationLevel authenticationLevel = AuthenticationLevel.getLevel((int)in.readInt());
        Dn dn = new Dn(schemaManager);
        try {
            dn.readExternal(in);
        }
        catch (ClassNotFoundException cnfe) {
            IOException ioe = new IOException(cnfe.getMessage());
            ioe.initCause(cnfe);
            throw ioe;
        }
        return new LdapPrincipal(schemaManager, dn, authenticationLevel);
    }
}

