/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hive;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class WebHCatServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "WEBHCAT";
    public static final String SERVICE_TYPE = "HIVE";
    public static final String ROLE_TYPE = "WEBHCAT";
    private static final String WEBHCAT_PORT = "hive_webhcat_address_port";

    @Override
    public String getService() {
        return "WEBHCAT";
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return "WEBHCAT";
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, WEBHCAT_PORT);
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "http://%s:%s/templeton", hostname, port));
        model.addRoleProperty(this.getRoleType(), WEBHCAT_PORT, this.getRoleConfigValue(roleConfig, WEBHCAT_PORT));
        return model;
    }
}

