/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.lucene.luke.app.DirectoryHandler;
import org.apache.lucene.luke.app.DirectoryObserver;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.LukeWindowOperator;
import org.apache.lucene.luke.app.desktop.components.MenuBarProvider;
import org.apache.lucene.luke.app.desktop.components.TabSwitcherProxy;
import org.apache.lucene.luke.app.desktop.components.TabbedPaneProvider;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.ImageUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.util.Version;

public final class LukeWindowProvider
implements LukeWindowOperator {
    private static final String WINDOW_TITLE = MessageUtils.getLocalizedMessage("window.title") + " - v" + Version.LATEST.toString();
    private final Preferences prefs;
    private final MessageBroker messageBroker;
    private final TabSwitcherProxy tabSwitcher;
    private final JMenuBar menuBar;
    private final JTabbedPane tabbedPane;
    private final JLabel messageLbl = new JLabel();
    private final JLabel multiIcon = new JLabel();
    private final JLabel readOnlyIcon = new JLabel();
    private final JLabel noReaderIcon = new JLabel();
    private JFrame frame = new JFrame();

    public LukeWindowProvider() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.menuBar = new MenuBarProvider().get();
        this.tabbedPane = new TabbedPaneProvider().get();
        this.messageBroker = MessageBroker.getInstance();
        this.tabSwitcher = TabSwitcherProxy.getInstance();
        ComponentOperatorRegistry.getInstance().register(LukeWindowOperator.class, this);
        Observer observer = new Observer();
        DirectoryHandler.getInstance().addObserver(observer);
        IndexHandler.getInstance().addObserver(observer);
        this.messageBroker.registerReceiver(new MessageReceiverImpl());
    }

    public JFrame get() {
        this.frame.setTitle(WINDOW_TITLE);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setJMenuBar(this.menuBar);
        this.frame.add((Component)this.initMainPanel(), "Center");
        this.frame.add((Component)this.initMessagePanel(), "Last");
        this.frame.setPreferredSize(new Dimension(950, 680));
        this.frame.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.frame;
    }

    private JPanel initMainPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        this.tabbedPane.setEnabledAt(TabbedPaneProvider.Tab.OVERVIEW.index(), false);
        this.tabbedPane.setEnabledAt(TabbedPaneProvider.Tab.DOCUMENTS.index(), false);
        this.tabbedPane.setEnabledAt(TabbedPaneProvider.Tab.SEARCH.index(), false);
        this.tabbedPane.setEnabledAt(TabbedPaneProvider.Tab.COMMITS.index(), false);
        panel.add(this.tabbedPane);
        panel.setOpaque(false);
        return panel;
    }

    private JPanel initMessagePanel() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        JPanel innerPanel = new JPanel(new GridBagLayout());
        innerPanel.setOpaque(false);
        innerPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        JPanel msgPanel = new JPanel(new FlowLayout(0));
        msgPanel.setOpaque(false);
        msgPanel.add(this.messageLbl);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.8;
        innerPanel.add((Component)msgPanel, c);
        JPanel iconPanel = new JPanel(new FlowLayout(2));
        iconPanel.setOpaque(false);
        this.multiIcon.setText(FontUtils.elegantIconHtml("&#xe08c;"));
        this.multiIcon.setToolTipText(MessageUtils.getLocalizedMessage("tooltip.multi_reader"));
        this.multiIcon.setVisible(false);
        iconPanel.add(this.multiIcon);
        this.readOnlyIcon.setText(FontUtils.elegantIconHtml("&#xe06c;"));
        this.readOnlyIcon.setToolTipText(MessageUtils.getLocalizedMessage("tooltip.read_only"));
        this.readOnlyIcon.setVisible(false);
        iconPanel.add(this.readOnlyIcon);
        this.noReaderIcon.setText(FontUtils.elegantIconHtml("&#xe077;"));
        this.noReaderIcon.setToolTipText(MessageUtils.getLocalizedMessage("tooltip.no_reader"));
        this.noReaderIcon.setVisible(false);
        iconPanel.add(this.noReaderIcon);
        JLabel luceneIcon = new JLabel(ImageUtils.createImageIcon("lucene.gif", "lucene", 16, 16));
        iconPanel.add(luceneIcon);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.2;
        innerPanel.add(iconPanel);
        panel.add(innerPanel);
        return panel;
    }

    @Override
    public void setColorTheme(Preferences.ColorTheme theme) {
        this.frame.getContentPane().setBackground(theme.getBackgroundColor());
    }

    private class MessageReceiverImpl
    implements MessageBroker.MessageReceiver {
        @Override
        public void showStatusMessage(String message) {
            LukeWindowProvider.this.messageLbl.setText(message);
        }

        @Override
        public void showUnknownErrorMessage() {
            LukeWindowProvider.this.messageLbl.setText(MessageUtils.getLocalizedMessage("message.error.unknown"));
        }

        @Override
        public void clearStatusMessage() {
            LukeWindowProvider.this.messageLbl.setText("");
        }

        private MessageReceiverImpl() {
        }
    }

    private class Observer
    implements IndexObserver,
    DirectoryObserver {
        private Observer() {
        }

        @Override
        public void openDirectory(LukeState state) {
            LukeWindowProvider.this.multiIcon.setVisible(false);
            LukeWindowProvider.this.readOnlyIcon.setVisible(false);
            LukeWindowProvider.this.noReaderIcon.setVisible(true);
            LukeWindowProvider.this.tabSwitcher.switchTab(TabbedPaneProvider.Tab.COMMITS);
            LukeWindowProvider.this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("message.directory_opened"));
        }

        @Override
        public void closeDirectory() {
            LukeWindowProvider.this.multiIcon.setVisible(false);
            LukeWindowProvider.this.readOnlyIcon.setVisible(false);
            LukeWindowProvider.this.noReaderIcon.setVisible(false);
            LukeWindowProvider.this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("message.directory_closed"));
        }

        @Override
        public void openIndex(LukeState state) {
            LukeWindowProvider.this.multiIcon.setVisible(!state.hasDirectoryReader());
            LukeWindowProvider.this.readOnlyIcon.setVisible(state.readOnly());
            LukeWindowProvider.this.noReaderIcon.setVisible(false);
            if (state.readOnly()) {
                LukeWindowProvider.this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("message.index_opened_ro"));
            } else if (!state.hasDirectoryReader()) {
                LukeWindowProvider.this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("message.index_opened_multi"));
            } else {
                LukeWindowProvider.this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("message.index_opened"));
            }
        }

        @Override
        public void closeIndex() {
            LukeWindowProvider.this.multiIcon.setVisible(false);
            LukeWindowProvider.this.readOnlyIcon.setVisible(false);
            LukeWindowProvider.this.noReaderIcon.setVisible(false);
            LukeWindowProvider.this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("message.index_closed"));
        }
    }
}

