/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.analysis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.app.desktop.components.AnalysisTabOperator;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.EditFiltersDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.EditFiltersMode;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.EditParamsDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.EditParamsMode;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.CustomAnalyzerPanelOperator;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.ListUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.app.desktop.util.lang.Callable;
import org.apache.lucene.luke.models.analysis.Analysis;
import org.apache.lucene.luke.models.analysis.CustomAnalyzerConfig;
import org.apache.lucene.util.SuppressForbidden;

public final class CustomAnalyzerPanelProvider
implements CustomAnalyzerPanelOperator {
    private final ComponentOperatorRegistry operatorRegistry;
    private final EditParamsDialogFactory editParamsDialogFactory;
    private final EditFiltersDialogFactory editFiltersDialogFactory;
    private final MessageBroker messageBroker;
    private final JTextField confDirTF = new JTextField();
    private final JFileChooser fileChooser = new JFileChooser();
    private final JButton confDirBtn = new JButton();
    private final JButton buildBtn = new JButton();
    private final JLabel loadJarLbl = new JLabel();
    private final JList<String> selectedCfList = new JList<String>(new String[0]);
    private final JButton cfEditBtn = new JButton();
    private final JComboBox<String> cfFactoryCombo = new JComboBox();
    private final JTextField selectedTokTF = new JTextField();
    private final JButton tokEditBtn = new JButton();
    private final JComboBox<String> tokFactoryCombo = new JComboBox();
    private final JList<String> selectedTfList = new JList<String>(new String[0]);
    private final JButton tfEditBtn = new JButton();
    private final JComboBox<String> tfFactoryCombo = new JComboBox();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private final List<Map<String, String>> cfParamsList = new ArrayList<Map<String, String>>();
    private final Map<String, String> tokParams = new HashMap<String, String>();
    private final List<Map<String, String>> tfParamsList = new ArrayList<Map<String, String>>();
    private JPanel containerPanel;
    private Analysis analysisModel;

    public CustomAnalyzerPanelProvider() throws IOException {
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.editParamsDialogFactory = EditParamsDialogFactory.getInstance();
        this.editFiltersDialogFactory = EditFiltersDialogFactory.getInstance();
        this.messageBroker = MessageBroker.getInstance();
        this.operatorRegistry.register(CustomAnalyzerPanelOperator.class, this);
        this.cfFactoryCombo.addActionListener(this.listeners::addCharFilter);
        this.tokFactoryCombo.addActionListener(this.listeners::setTokenizer);
        this.tfFactoryCombo.addActionListener(this.listeners::addTokenFilter);
    }

    public JPanel get() {
        if (this.containerPanel == null) {
            this.containerPanel = new JPanel();
            this.containerPanel.setOpaque(false);
            this.containerPanel.setLayout(new BorderLayout());
            this.containerPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.containerPanel.add((Component)this.initCustomAnalyzerHeaderPanel(), "First");
            this.containerPanel.add((Component)this.initCustomAnalyzerChainPanel(), "Center");
        }
        return this.containerPanel;
    }

    private JPanel initCustomAnalyzerHeaderPanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setOpaque(false);
        panel.add(new JLabel(MessageUtils.getLocalizedMessage("analysis.label.config_dir")));
        this.confDirTF.setColumns(30);
        this.confDirTF.setPreferredSize(new Dimension(200, 30));
        panel.add(this.confDirTF);
        this.confDirBtn.setText(FontUtils.elegantIconHtml("&#x6e;", MessageUtils.getLocalizedMessage("analysis.button.browse")));
        this.confDirBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.confDirBtn.setMargin(new Insets(3, 3, 3, 3));
        this.confDirBtn.addActionListener(this.listeners::chooseConfigDir);
        panel.add(this.confDirBtn);
        this.buildBtn.setText(FontUtils.elegantIconHtml("&#xe102;", MessageUtils.getLocalizedMessage("analysis.button.build_analyzser")));
        this.buildBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.buildBtn.setMargin(new Insets(3, 3, 3, 3));
        this.buildBtn.addActionListener(this.listeners::buildAnalyzer);
        panel.add(this.buildBtn);
        this.loadJarLbl.setText(MessageUtils.getLocalizedMessage("analysis.hyperlink.load_jars"));
        this.loadJarLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CustomAnalyzerPanelProvider.this.listeners.loadExternalJars(e);
            }
        });
        panel.add(FontUtils.toLinkText(this.loadJarLbl));
        return panel;
    }

    private JPanel initCustomAnalyzerChainPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add(this.initCustomChainConfigPanel());
        return panel;
    }

    private JPanel initCustomChainConfigPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        GridBagConstraints sepc = new GridBagConstraints();
        sepc.fill = 2;
        sepc.weightx = 1.0;
        sepc.gridwidth = 0;
        JLabel cfLbl = new JLabel(MessageUtils.getLocalizedMessage("analysis_custom.label.charfilters"));
        cfLbl.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 10;
        panel.add((Component)cfLbl, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("analysis_custom.label.selected")), c);
        this.selectedCfList.setVisibleRowCount(1);
        this.selectedCfList.setFont(new Font(this.selectedCfList.getFont().getFontName(), 0, 15));
        JScrollPane selectedPanel = new JScrollPane(this.selectedCfList);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add((Component)selectedPanel, c);
        this.cfEditBtn.setText(FontUtils.elegantIconHtml("&#x6a;", MessageUtils.getLocalizedMessage("analysis_custom.label.edit")));
        this.cfEditBtn.setMargin(new Insets(2, 4, 2, 4));
        this.cfEditBtn.setEnabled(false);
        this.cfEditBtn.addActionListener(this.listeners::editCharFilters);
        c.fill = 0;
        c.gridx = 7;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 10;
        panel.add((Component)this.cfEditBtn, c);
        JLabel cfAddLabel = new JLabel(FontUtils.elegantIconHtml("&#x4c;", MessageUtils.getLocalizedMessage("analysis_custom.label.add")));
        cfAddLabel.setHorizontalAlignment(2);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add((Component)cfAddLabel, c);
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add(this.cfFactoryCombo, c);
        sepc.gridx = 0;
        sepc.gridy = 3;
        sepc.anchor = 21;
        panel.add((Component)new JSeparator(0), sepc);
        JLabel tokLabel = new JLabel(MessageUtils.getLocalizedMessage("analysis_custom.label.tokenizer"));
        tokLabel.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 10;
        panel.add((Component)tokLabel, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("analysis_custom.label.selected")), c);
        this.selectedTokTF.setColumns(15);
        this.selectedTokTF.setFont(new Font(this.selectedTokTF.getFont().getFontName(), 0, 15));
        this.selectedTokTF.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.selectedTokTF.setText("standard");
        this.selectedTokTF.setEditable(false);
        c.gridx = 2;
        c.gridy = 4;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add((Component)this.selectedTokTF, c);
        this.tokEditBtn.setText(FontUtils.elegantIconHtml("&#x6a;", MessageUtils.getLocalizedMessage("analysis_custom.label.edit")));
        this.tokEditBtn.setMargin(new Insets(2, 4, 2, 4));
        this.tokEditBtn.addActionListener(this.listeners::editTokenizer);
        c.fill = 0;
        c.gridx = 7;
        c.gridy = 4;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 10;
        panel.add((Component)this.tokEditBtn, c);
        JLabel setTokLabel = new JLabel(FontUtils.elegantIconHtml("&#xe01e;", MessageUtils.getLocalizedMessage("analysis_custom.label.set")));
        setTokLabel.setHorizontalAlignment(2);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add((Component)setTokLabel, c);
        c.gridx = 2;
        c.gridy = 6;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add(this.tokFactoryCombo, c);
        sepc.gridx = 0;
        sepc.gridy = 7;
        sepc.anchor = 21;
        panel.add((Component)new JSeparator(0), sepc);
        JLabel tfLbl = new JLabel(MessageUtils.getLocalizedMessage("analysis_custom.label.tokenfilters"));
        tfLbl.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 10;
        panel.add((Component)tfLbl, c);
        c.gridx = 1;
        c.gridy = 8;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("analysis_custom.label.selected")), c);
        this.selectedTfList.setVisibleRowCount(1);
        this.selectedTfList.setFont(new Font(this.selectedTfList.getFont().getFontName(), 0, 15));
        JScrollPane selectedTfPanel = new JScrollPane(this.selectedTfList);
        c.gridx = 2;
        c.gridy = 8;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add((Component)selectedTfPanel, c);
        this.tfEditBtn.setText(FontUtils.elegantIconHtml("&#x6a;", MessageUtils.getLocalizedMessage("analysis_custom.label.edit")));
        this.tfEditBtn.setMargin(new Insets(2, 4, 2, 4));
        this.tfEditBtn.setEnabled(false);
        this.tfEditBtn.addActionListener(this.listeners::editTokenFilters);
        c.fill = 0;
        c.gridx = 7;
        c.gridy = 8;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 10;
        panel.add((Component)this.tfEditBtn, c);
        JLabel tfAddLabel = new JLabel(FontUtils.elegantIconHtml("&#x4c;", MessageUtils.getLocalizedMessage("analysis_custom.label.add")));
        tfAddLabel.setHorizontalAlignment(2);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 10;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.1;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add((Component)tfAddLabel, c);
        c.gridx = 2;
        c.gridy = 10;
        c.gridwidth = 5;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.anchor = 22;
        panel.add(this.tfFactoryCombo, c);
        return panel;
    }

    @SuppressForbidden(reason="JFilechooser#getSelectedFile() returns java.io.File")
    private void chooseConfigDir() {
        this.fileChooser.setFileSelectionMode(1);
        int ret = this.fileChooser.showOpenDialog(this.containerPanel);
        if (ret == 0) {
            File dir = this.fileChooser.getSelectedFile();
            this.confDirTF.setText(dir.getAbsolutePath());
        }
    }

    @SuppressForbidden(reason="JFilechooser#getSelectedFiles() returns java.io.File[]")
    private void loadExternalJars() {
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(true);
        int ret = this.fileChooser.showOpenDialog(this.containerPanel);
        if (ret == 0) {
            File[] files = this.fileChooser.getSelectedFiles();
            this.analysisModel.addExternalJars(Arrays.stream(files).map(File::getAbsolutePath).collect(Collectors.toList()));
            this.operatorRegistry.get(CustomAnalyzerPanelOperator.class).ifPresent(operator -> operator.resetAnalysisComponents());
            this.messageBroker.showStatusMessage("External jars were added.");
        }
    }

    private void buildAnalyzer() {
        List<String> charFilters = ListUtils.getAllItems(this.selectedCfList);
        assert (charFilters.size() == this.cfParamsList.size());
        List<String> tokenFilters = ListUtils.getAllItems(this.selectedTfList);
        assert (tokenFilters.size() == this.tfParamsList.size());
        String tokenizerName = this.selectedTokTF.getText();
        CustomAnalyzerConfig.Builder builder = new CustomAnalyzerConfig.Builder(tokenizerName, this.tokParams).configDir(this.confDirTF.getText());
        IntStream.range(0, charFilters.size()).forEach(i -> builder.addCharFilterConfig((String)charFilters.get(i), this.cfParamsList.get(i)));
        IntStream.range(0, tokenFilters.size()).forEach(i -> builder.addTokenFilterConfig((String)tokenFilters.get(i), this.tfParamsList.get(i)));
        CustomAnalyzerConfig config = builder.build();
        this.operatorRegistry.get(AnalysisTabOperator.class).ifPresent(operator -> {
            operator.setAnalyzerByCustomConfiguration(config);
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("analysis.message.build_success"));
            this.buildBtn.setEnabled(false);
        });
    }

    private void addCharFilter() {
        if (Objects.isNull(this.cfFactoryCombo.getSelectedItem()) || this.cfFactoryCombo.getSelectedItem() == "") {
            return;
        }
        int targetIndex = this.selectedCfList.getModel().getSize();
        String selectedItem = (String)this.cfFactoryCombo.getSelectedItem();
        List<String> updatedList = ListUtils.getAllItems(this.selectedCfList);
        updatedList.add(selectedItem);
        this.cfParamsList.add(new HashMap());
        assert (this.selectedCfList.getModel().getSize() == this.cfParamsList.size());
        this.showEditParamsDialog(MessageUtils.getLocalizedMessage("analysis.dialog.title.char_filter_params"), EditParamsMode.CHARFILTER, targetIndex, selectedItem, this.cfParamsList.get(this.cfParamsList.size() - 1), () -> {
            this.selectedCfList.setModel(new DefaultComboBoxModel<String>(updatedList.toArray(new String[0])));
            this.cfFactoryCombo.setSelectedItem("");
            this.cfEditBtn.setEnabled(true);
            this.buildBtn.setEnabled(true);
        });
    }

    private void setTokenizer() {
        if (Objects.isNull(this.tokFactoryCombo.getSelectedItem()) || this.tokFactoryCombo.getSelectedItem() == "") {
            return;
        }
        String selectedItem = (String)this.tokFactoryCombo.getSelectedItem();
        this.showEditParamsDialog(MessageUtils.getLocalizedMessage("analysis.dialog.title.tokenizer_params"), EditParamsMode.TOKENIZER, -1, selectedItem, Collections.emptyMap(), () -> {
            this.selectedTokTF.setText(selectedItem);
            this.tokFactoryCombo.setSelectedItem("");
            this.buildBtn.setEnabled(true);
        });
    }

    private void addTokenFilter() {
        if (Objects.isNull(this.tfFactoryCombo.getSelectedItem()) || this.tfFactoryCombo.getSelectedItem() == "") {
            return;
        }
        int targetIndex = this.selectedTfList.getModel().getSize();
        String selectedItem = (String)this.tfFactoryCombo.getSelectedItem();
        List<String> updatedList = ListUtils.getAllItems(this.selectedTfList);
        updatedList.add(selectedItem);
        this.tfParamsList.add(new HashMap());
        assert (this.selectedTfList.getModel().getSize() == this.tfParamsList.size());
        this.showEditParamsDialog(MessageUtils.getLocalizedMessage("analysis.dialog.title.token_filter_params"), EditParamsMode.TOKENFILTER, targetIndex, selectedItem, this.tfParamsList.get(this.tfParamsList.size() - 1), () -> {
            this.selectedTfList.setModel(new DefaultComboBoxModel<String>(updatedList.toArray(new String[updatedList.size()])));
            this.tfFactoryCombo.setSelectedItem("");
            this.tfEditBtn.setEnabled(true);
            this.buildBtn.setEnabled(true);
        });
    }

    private void showEditParamsDialog(String title, EditParamsMode mode, int targetIndex, String selectedItem, Map<String, String> params, Callable callback) {
        new DialogOpener<EditParamsDialogFactory>(this.editParamsDialogFactory).open(title, 400, 300, factory -> {
            factory.setMode(mode);
            factory.setTargetIndex(targetIndex);
            factory.setTarget(selectedItem);
            factory.setParams(params);
            factory.setCallback(callback);
        }, new String[0]);
    }

    private void editCharFilters() {
        List<String> filters = ListUtils.getAllItems(this.selectedCfList);
        this.showEditFiltersDialog(EditFiltersMode.CHARFILTER, filters, () -> {
            this.cfEditBtn.setEnabled(this.selectedCfList.getModel().getSize() > 0);
            this.buildBtn.setEnabled(true);
        });
    }

    private void editTokenizer() {
        String selectedItem = this.selectedTokTF.getText();
        this.showEditParamsDialog(MessageUtils.getLocalizedMessage("analysis.dialog.title.tokenizer_params"), EditParamsMode.TOKENIZER, -1, selectedItem, this.tokParams, () -> this.buildBtn.setEnabled(true));
    }

    private void editTokenFilters() {
        List<String> filters = ListUtils.getAllItems(this.selectedTfList);
        this.showEditFiltersDialog(EditFiltersMode.TOKENFILTER, filters, () -> {
            this.tfEditBtn.setEnabled(this.selectedTfList.getModel().getSize() > 0);
            this.buildBtn.setEnabled(true);
        });
    }

    private void showEditFiltersDialog(EditFiltersMode mode, List<String> selectedFilters, Callable callback) {
        String title = mode == EditFiltersMode.CHARFILTER ? MessageUtils.getLocalizedMessage("analysis.dialog.title.selected_char_filter") : MessageUtils.getLocalizedMessage("analysis.dialog.title.selected_token_filter");
        new DialogOpener<EditFiltersDialogFactory>(this.editFiltersDialogFactory).open(title, 400, 300, factory -> {
            factory.setMode(mode);
            factory.setSelectedFilters(selectedFilters);
            factory.setCallback(callback);
        }, new String[0]);
    }

    @Override
    public void setAnalysisModel(Analysis model) {
        this.analysisModel = model;
    }

    @Override
    public void resetAnalysisComponents() {
        this.setAvailableCharFilterFactories();
        this.setAvailableTokenizerFactories();
        this.setAvailableTokenFilterFactories();
        this.buildBtn.setEnabled(true);
    }

    private void setAvailableCharFilterFactories() {
        Collection<String> charFilters = this.analysisModel.getAvailableCharFilters();
        String[] charFilterNames = new String[charFilters.size() + 1];
        charFilterNames[0] = "";
        System.arraycopy(charFilters.toArray(new String[0]), 0, charFilterNames, 1, charFilters.size());
        this.cfFactoryCombo.setModel(new DefaultComboBoxModel<String>(charFilterNames));
    }

    private void setAvailableTokenizerFactories() {
        Collection<String> tokenizers = this.analysisModel.getAvailableTokenizers();
        String[] tokenizerNames = new String[tokenizers.size() + 1];
        tokenizerNames[0] = "";
        System.arraycopy(tokenizers.toArray(new String[0]), 0, tokenizerNames, 1, tokenizers.size());
        this.tokFactoryCombo.setModel(new DefaultComboBoxModel<String>(tokenizerNames));
    }

    private void setAvailableTokenFilterFactories() {
        Collection<String> tokenFilters = this.analysisModel.getAvailableTokenFilters();
        String[] tokenFilterNames = new String[tokenFilters.size() + 1];
        tokenFilterNames[0] = "";
        System.arraycopy(tokenFilters.toArray(new String[0]), 0, tokenFilterNames, 1, tokenFilters.size());
        this.tfFactoryCombo.setModel(new DefaultComboBoxModel<String>(tokenFilterNames));
    }

    @Override
    public void updateCharFilters(List<Integer> deletedIndexes) {
        List<String> filters = ListUtils.getAllItems(this.selectedCfList);
        String[] updatedFilters = (String[])IntStream.range(0, filters.size()).filter(i -> !deletedIndexes.contains(i)).mapToObj(filters::get).toArray(String[]::new);
        this.selectedCfList.setModel(new DefaultComboBoxModel<String>(updatedFilters));
        List updatedParamList = IntStream.range(0, this.cfParamsList.size()).filter(i -> !deletedIndexes.contains(i)).mapToObj(this.cfParamsList::get).collect(Collectors.toList());
        this.cfParamsList.clear();
        this.cfParamsList.addAll(updatedParamList);
        assert (this.selectedCfList.getModel().getSize() == this.cfParamsList.size());
    }

    @Override
    public void updateTokenFilters(List<Integer> deletedIndexes) {
        List<String> filters = ListUtils.getAllItems(this.selectedTfList);
        String[] updatedFilters = (String[])IntStream.range(0, filters.size()).filter(i -> !deletedIndexes.contains(i)).mapToObj(filters::get).toArray(String[]::new);
        this.selectedTfList.setModel(new DefaultComboBoxModel<String>(updatedFilters));
        List updatedParamList = IntStream.range(0, this.tfParamsList.size()).filter(i -> !deletedIndexes.contains(i)).mapToObj(this.tfParamsList::get).collect(Collectors.toList());
        this.tfParamsList.clear();
        this.tfParamsList.addAll(updatedParamList);
        assert (this.selectedTfList.getModel().getSize() == this.tfParamsList.size());
    }

    @Override
    public Map<String, String> getCharFilterParams(int index) {
        if (index < 0 || index > this.cfParamsList.size()) {
            throw new IllegalArgumentException();
        }
        return Map.copyOf(this.cfParamsList.get(index));
    }

    @Override
    public void updateCharFilterParams(int index, Map<String, String> updatedParams) {
        if (index < 0 || index > this.cfParamsList.size()) {
            throw new IllegalArgumentException();
        }
        if (index == this.cfParamsList.size()) {
            this.cfParamsList.add(new HashMap());
        }
        this.cfParamsList.get(index).clear();
        this.cfParamsList.get(index).putAll(updatedParams);
    }

    @Override
    public void updateTokenizerParams(Map<String, String> updatedParams) {
        this.tokParams.clear();
        this.tokParams.putAll(updatedParams);
    }

    @Override
    public Map<String, String> getTokenFilterParams(int index) {
        if (index < 0 || index > this.tfParamsList.size()) {
            throw new IllegalArgumentException();
        }
        return Map.copyOf(this.tfParamsList.get(index));
    }

    @Override
    public void updateTokenFilterParams(int index, Map<String, String> updatedParams) {
        if (index < 0 || index > this.tfParamsList.size()) {
            throw new IllegalArgumentException();
        }
        if (index == this.tfParamsList.size()) {
            this.tfParamsList.add(new HashMap());
        }
        this.tfParamsList.get(index).clear();
        this.tfParamsList.get(index).putAll(updatedParams);
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void chooseConfigDir(ActionEvent e) {
            CustomAnalyzerPanelProvider.this.chooseConfigDir();
        }

        void loadExternalJars(MouseEvent e) {
            CustomAnalyzerPanelProvider.this.loadExternalJars();
        }

        void buildAnalyzer(ActionEvent e) {
            CustomAnalyzerPanelProvider.this.buildAnalyzer();
        }

        void addCharFilter(ActionEvent e) {
            CustomAnalyzerPanelProvider.this.addCharFilter();
        }

        void setTokenizer(ActionEvent e) {
            CustomAnalyzerPanelProvider.this.setTokenizer();
        }

        void addTokenFilter(ActionEvent e) {
            CustomAnalyzerPanelProvider.this.addTokenFilter();
        }

        void editCharFilters(ActionEvent e) {
            CustomAnalyzerPanelProvider.this.editCharFilters();
        }

        void editTokenizer(ActionEvent e) {
            CustomAnalyzerPanelProvider.this.editTokenizer();
        }

        void editTokenFilters(ActionEvent e) {
            CustomAnalyzerPanelProvider.this.editTokenFilters();
        }
    }
}

