/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.List;

public interface ZkCredentialsInjector {
    public List<ZkCredential> getZkCredentials();

    public static class ZkCredential {
        private String username;
        private String password;
        private String perms;

        public ZkCredential() {
        }

        public ZkCredential(String username, String password, Perms perms) {
            this(username, password, String.valueOf((Object)perms));
        }

        public ZkCredential(String username, String password, String perms) {
            this.username = username;
            this.password = password;
            this.perms = perms;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPerms() {
            return this.perms;
        }

        public boolean isAll() {
            return Perms.ALL.toString().equalsIgnoreCase(this.perms);
        }

        public boolean isReadonly() {
            return Perms.READ.toString().equalsIgnoreCase(this.perms);
        }

        public String toString() {
            return "ZkCredential{username='" + this.username + "', password=[hidden], perms='" + this.perms + "'}";
        }

        public static enum Perms {
            ALL,
            READ;

        }
    }
}

