/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;

public class LobStorage {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    public static final int TABLE_TEMP = -2;
    public static final String LOB_DATA_TABLE = "LOB_DATA";
    private static final String LOB_SCHEMA = "INFORMATION_SCHEMA";
    private static final String LOBS = "INFORMATION_SCHEMA.LOBS";
    private static final String LOB_MAP = "INFORMATION_SCHEMA.LOB_MAP";
    private static final String LOB_DATA = "INFORMATION_SCHEMA.LOB_DATA";
    private static final int BLOCK_LENGTH = 20000;
    private static final int HASH_CACHE_SIZE = 4096;
    private Connection conn;
    private HashMap<String, PreparedStatement> prepared = New.hashMap();
    private long nextBlock;
    private CompressTool compress = CompressTool.getInstance();
    private long[] hashBlocks = new long[8192];
    private final DataHandler handler;
    private boolean init;

    public LobStorage(DataHandler dataHandler) {
        this.handler = dataHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.init) {
            return;
        }
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            this.conn = this.handler.getLobConnection();
            this.init = true;
            if (this.conn == null) {
                return;
            }
            try {
                Statement statement = this.conn.createStatement();
                statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOBS(ID BIGINT PRIMARY KEY, BYTE_COUNT BIGINT, TABLE INT) HIDDEN");
                statement.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_TABLE ON INFORMATION_SCHEMA.LOBS(TABLE)");
                statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_MAP(LOB BIGINT, SEQ INT, POS BIGINT, HASH INT, BLOCK BIGINT, PRIMARY KEY(LOB, SEQ)) HIDDEN");
                statement.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP RENAME TO INFORMATION_SCHEMA.LOB_MAP HIDDEN");
                statement.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP ADD IF NOT EXISTS POS BIGINT BEFORE HASH");
                statement.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP DROP COLUMN IF EXISTS \"OFFSET\"");
                statement.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_MAP_DATA_LOB ON INFORMATION_SCHEMA.LOB_MAP(BLOCK, LOB)");
                statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_DATA(BLOCK BIGINT PRIMARY KEY, COMPRESSED INT, DATA BINARY) HIDDEN");
                ResultSet resultSet = statement.executeQuery("SELECT MAX(BLOCK) FROM INFORMATION_SCHEMA.LOB_DATA");
                resultSet.next();
                this.nextBlock = resultSet.getLong(1) + 1L;
                statement.close();
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
    }

    private long getNextLobId() throws SQLException {
        String string = "SELECT MAX(LOB) FROM INFORMATION_SCHEMA.LOB_MAP";
        PreparedStatement preparedStatement = this.prepare(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        long l = resultSet.getLong(1) + 1L;
        this.reuse(string, preparedStatement);
        string = "SELECT MAX(ID) FROM INFORMATION_SCHEMA.LOBS";
        preparedStatement = this.prepare(string);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        l = Math.max(l, resultSet.getLong(1) + 1L);
        this.reuse(string, preparedStatement);
        return l;
    }

    public void removeAllForTable(int n) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            try {
                String string = "SELECT ID FROM INFORMATION_SCHEMA.LOBS WHERE TABLE = ?";
                PreparedStatement preparedStatement = this.prepare(string);
                preparedStatement.setInt(1, n);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.removeLob(resultSet.getLong(1));
                }
                this.reuse(string, preparedStatement);
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
            if (n == -1) {
                this.removeAllForTable(-2);
            }
        }
        ValueLob.removeAllForTable(this.handler, n);
    }

    public static Value createSmallLob(int n, byte[] byArray) {
        if (SysProperties.LOB_IN_DATABASE) {
            int n2 = n == 16 ? StringUtils.utf8Decode(byArray).length() : byArray.length;
            return ValueLobDb.createSmallLob(n, byArray, n2);
        }
        return ValueLob.createSmallLob(n, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readBlock(long l, int n) throws SQLException {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            String string = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_MAP M INNER JOIN INFORMATION_SCHEMA.LOB_DATA D ON M.BLOCK = D.BLOCK WHERE M.LOB = ? AND M.SEQ = ?";
            PreparedStatement preparedStatement = this.prepare(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw DbException.get(90028, "Missing lob entry: " + l + "/" + n).getSQLException();
            }
            int n2 = resultSet.getInt(1);
            byte[] byArray = resultSet.getBytes(2);
            if (n2 != 0) {
                byArray = this.compress.expand(byArray);
            }
            this.reuse(string, preparedStatement);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] skipBuffer(long l, long l2) throws SQLException {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            long[] lArray;
            String string = "SELECT MAX(SEQ), MAX(POS) FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ? AND POS < ?";
            PreparedStatement preparedStatement = this.prepare(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt(1);
            l2 = resultSet.getLong(2);
            boolean bl = resultSet.wasNull();
            resultSet.close();
            this.reuse(string, preparedStatement);
            if (bl) {
                lArray = null;
            } else {
                long[] lArray2 = new long[2];
                lArray2[0] = n;
                lArray = lArray2;
                lArray2[1] = l2;
            }
            return lArray;
        }
    }

    private PreparedStatement prepare(String string) throws SQLException {
        if (SysProperties.CHECK2 && !Thread.holdsLock(this.handler)) {
            throw DbException.throwInternalError();
        }
        PreparedStatement preparedStatement = this.prepared.remove(string);
        if (preparedStatement == null) {
            preparedStatement = this.conn.prepareStatement(string);
        }
        return preparedStatement;
    }

    private void reuse(String string, PreparedStatement preparedStatement) {
        if (SysProperties.CHECK2 && !Thread.holdsLock(this.handler)) {
            throw DbException.throwInternalError();
        }
        this.prepared.put(string, preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLob(long l) {
        try {
            DataHandler dataHandler = this.handler;
            synchronized (dataHandler) {
                if (this.conn == null) {
                    return;
                }
                String string = "SELECT BLOCK, HASH FROM INFORMATION_SCHEMA.LOB_MAP D WHERE D.LOB = ? AND NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.LOB_MAP O WHERE O.BLOCK = D.BLOCK AND O.LOB <> ?)";
                PreparedStatement preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l);
                preparedStatement.setLong(2, l);
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList arrayList = New.arrayList();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getLong(1));
                    int n = resultSet.getInt(2);
                    this.setHashCacheBlock(n, -1L);
                }
                this.reuse(string, preparedStatement);
                string = "DELETE FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l);
                preparedStatement.execute();
                this.reuse(string, preparedStatement);
                string = "DELETE FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                preparedStatement = this.prepare(string);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    long l2 = (Long)iterator.next();
                    preparedStatement.setLong(1, l2);
                    preparedStatement.execute();
                }
                this.reuse(string, preparedStatement);
                string = "DELETE FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l);
                preparedStatement.execute();
                this.reuse(string, preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(long l, long l2) throws IOException {
        this.init();
        if (l2 == -1L) {
            DataHandler dataHandler = this.handler;
            synchronized (dataHandler) {
                try {
                    String string = "SELECT BYTE_COUNT FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                    PreparedStatement preparedStatement = this.prepare(string);
                    preparedStatement.setLong(1, l);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw DbException.get(90028, "Missing lob: " + l).getSQLException();
                    }
                    l2 = resultSet.getLong(1);
                    this.reuse(string, preparedStatement);
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }
        }
        return new LobInputStream(l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb addLob(InputStream inputStream, long l, int n) {
        try {
            byte[] byArray = new byte[20000];
            if (l < 0L) {
                l = Long.MAX_VALUE;
            }
            long l2 = 0L;
            long l3 = -1L;
            int n2 = this.handler.getMaxLengthInplaceLob();
            String string = this.handler.getLobCompressionAlgorithm(n);
            try {
                byte[] byArray2 = null;
                int n3 = 0;
                while (l > 0L) {
                    byte[] byArray3;
                    int n4 = (int)Math.min(20000L, l);
                    if ((n4 = IOUtils.readFully(inputStream, byArray, 0, n4)) <= 0) break;
                    l -= (long)n4;
                    if (n4 != byArray.length) {
                        byArray3 = new byte[n4];
                        System.arraycopy(byArray, 0, byArray3, 0, n4);
                    } else {
                        byArray3 = byArray;
                    }
                    if (n3 == 0 && byArray3.length < 20000 && byArray3.length <= n2) {
                        byArray2 = byArray3;
                        break;
                    }
                    DataHandler dataHandler = this.handler;
                    synchronized (dataHandler) {
                        if (n3 == 0) {
                            l3 = this.getNextLobId();
                        }
                        this.storeBlock(l3, n3, l2, byArray3, string);
                    }
                    l2 += (long)n4;
                    ++n3;
                }
                if (l3 == -1L && byArray2 == null) {
                    byArray2 = new byte[]{};
                }
                if (byArray2 != null) {
                    ValueLobDb valueLobDb = ValueLobDb.createSmallLob(n, byArray2, byArray2.length);
                    return valueLobDb;
                }
                return this.registerLob(n, l3, -2, l2);
            }
            catch (IOException iOException) {
                if (l3 != -1L) {
                    this.removeLob(l3);
                }
                throw DbException.convertIOException(iOException, null);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    private ValueLobDb registerLob(int n, long l, int n2, long l2) {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            try {
                String string = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) VALUES(?, ?, ?)";
                PreparedStatement preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l);
                preparedStatement.setLong(2, l2);
                preparedStatement.setInt(3, n2);
                preparedStatement.execute();
                this.reuse(string, preparedStatement);
                ValueLobDb valueLobDb = ValueLobDb.create(n, this, null, n2, l, l2);
                return valueLobDb;
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
    }

    public ValueLobDb copyLob(int n, long l, int n2, long l2) {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            try {
                this.init();
                long l3 = this.getNextLobId();
                String string = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) SELECT ?, SEQ, POS, HASH, BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                PreparedStatement preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l3);
                preparedStatement.setLong(2, l);
                preparedStatement.executeUpdate();
                this.reuse(string, preparedStatement);
                string = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) SELECT ?, BYTE_COUNT, ? FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l3);
                preparedStatement.setLong(2, n2);
                preparedStatement.setLong(3, l);
                preparedStatement.executeUpdate();
                this.reuse(string, preparedStatement);
                ValueLobDb valueLobDb = ValueLobDb.create(n, this, null, n2, l3, l2);
                return valueLobDb;
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
    }

    private long getHashCacheBlock(int n) {
        int n2 = n & 0xFFF;
        long l = this.hashBlocks[n2];
        if (l == (long)n) {
            return this.hashBlocks[n2 + 4096];
        }
        return -1L;
    }

    private void setHashCacheBlock(int n, long l) {
        int n2 = n & 0xFFF;
        this.hashBlocks[n2] = n;
        this.hashBlocks[n2 + 4096] = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeBlock(long l, int n, long l2, byte[] byArray, String string) throws SQLException {
        boolean bl = false;
        if (string != null) {
            byArray = this.compress.compress(byArray, string);
        }
        int n2 = Arrays.hashCode(byArray);
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            PreparedStatement preparedStatement;
            String string2;
            long l3 = this.getHashCacheBlock(n2);
            if (l3 != -1L) {
                string2 = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                preparedStatement = this.prepare(string2);
                preparedStatement.setLong(1, l3);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    boolean bl2 = resultSet.getInt(1) != 0;
                    byte[] byArray2 = resultSet.getBytes(2);
                    if (bl2 == (string != null) && Arrays.equals(byArray, byArray2)) {
                        bl = true;
                    }
                }
                this.reuse(string2, preparedStatement);
            }
            if (!bl) {
                l3 = this.nextBlock++;
                this.setHashCacheBlock(n2, l3);
                string2 = "INSERT INTO INFORMATION_SCHEMA.LOB_DATA(BLOCK, COMPRESSED, DATA) VALUES(?, ?, ?)";
                preparedStatement = this.prepare(string2);
                preparedStatement.setLong(1, l3);
                preparedStatement.setInt(2, string == null ? 0 : 1);
                preparedStatement.setBytes(3, byArray);
                preparedStatement.execute();
                this.reuse(string2, preparedStatement);
            }
            string2 = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) VALUES(?, ?, ?, ?, ?)";
            preparedStatement = this.prepare(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n);
            preparedStatement.setLong(3, l2);
            preparedStatement.setLong(4, n2);
            preparedStatement.setLong(5, l3);
            preparedStatement.execute();
            this.reuse(string2, preparedStatement);
        }
    }

    public Value createBlob(InputStream inputStream, long l) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.conn == null) {
                return ValueLobDb.createTempBlob(inputStream, l, this.handler);
            }
            return this.addLob(inputStream, l, 15);
        }
        return ValueLob.createBlob(inputStream, l, this.handler);
    }

    public Value createClob(Reader reader, long l) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.conn == null) {
                return ValueLobDb.createTempClob(reader, l, this.handler);
            }
            long l2 = l == -1L ? Long.MAX_VALUE : l;
            CountingReaderInputStream countingReaderInputStream = new CountingReaderInputStream(reader, l2);
            ValueLobDb valueLobDb = this.addLob(countingReaderInputStream, Long.MAX_VALUE, 16);
            valueLobDb.setPrecision(countingReaderInputStream.getLength());
            return valueLobDb;
        }
        return ValueLob.createClob(reader, l, this.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(long l, int n) {
        DataHandler dataHandler = this.handler;
        synchronized (dataHandler) {
            try {
                this.init();
                String string = "UPDATE INFORMATION_SCHEMA.LOBS SET TABLE = ? WHERE ID = ?";
                PreparedStatement preparedStatement = this.prepare(string);
                preparedStatement.setInt(1, n);
                preparedStatement.setLong(2, l);
                preparedStatement.executeUpdate();
                this.reuse(string, preparedStatement);
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
    }

    static class CountingReaderInputStream
    extends InputStream {
        private final Reader reader;
        private long length;
        private long remaining;
        private int pos;
        private char[] charBuffer = new char[4096];
        private byte[] buffer;

        CountingReaderInputStream(Reader reader, long l) {
            this.reader = reader;
            this.remaining = l;
            this.buffer = Utils.EMPTY_BYTES;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.pos >= this.buffer.length) {
                this.fillBuffer();
                if (this.buffer == null) {
                    return -1;
                }
            }
            n2 = Math.min(n2, this.buffer.length - this.pos);
            System.arraycopy(this.buffer, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }

        public int read() throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            if (this.pos >= this.buffer.length) {
                this.fillBuffer();
                if (this.buffer == null) {
                    return -1;
                }
            }
            return this.buffer[this.pos++];
        }

        private void fillBuffer() throws IOException {
            int n = (int)Math.min((long)this.charBuffer.length, this.remaining);
            n = n > 0 ? this.reader.read(this.charBuffer, 0, n) : -1;
            if (n < 0) {
                this.buffer = null;
            } else {
                this.buffer = StringUtils.utf8Encode(new String(this.charBuffer, 0, n));
                this.length += (long)n;
                this.remaining -= (long)n;
            }
            this.pos = 0;
        }

        public long getLength() {
            return this.length;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    public class LobInputStream
    extends InputStream {
        private byte[] buffer;
        private long length;
        private int pos;
        private long remainingBytes;
        private long lob;
        private int seq;

        public LobInputStream(long l, long l2) {
            this.lob = l;
            this.remainingBytes = l2;
            this.length = l2;
        }

        public int read() throws IOException {
            this.fillBuffer();
            if (this.remainingBytes <= 0L) {
                return -1;
            }
            --this.remainingBytes;
            return this.buffer[this.pos++] & 0xFF;
        }

        public long skip(long l) throws IOException {
            if ((l -= (long)this.skipSmall(l)) > 20000L) {
                long l2 = this.length - this.remainingBytes + l;
                try {
                    long[] lArray = LobStorage.this.skipBuffer(this.lob, l2);
                    if (lArray == null) {
                        return super.skip(l);
                    }
                    this.seq = (int)lArray[0];
                    l = l2 - lArray[1];
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
                this.pos = 0;
                this.buffer = null;
            }
            this.fillBuffer();
            l -= (long)this.skipSmall(l);
            return super.skip(l);
        }

        private int skipSmall(long l) {
            if (l > 0L && this.buffer != null && this.pos < this.buffer.length) {
                int n = MathUtils.convertLongToInt(Math.min(l, (long)(this.buffer.length - this.pos)));
                l -= (long)n;
                this.pos += n;
                this.remainingBytes -= (long)n;
                return n;
            }
            return 0;
        }

        public int read(byte[] byArray) throws IOException {
            return this.readFully(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.readFully(byArray, n, n2);
        }

        private int readFully(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            while (n2 > 0) {
                this.fillBuffer();
                if (this.remainingBytes <= 0L) break;
                int n4 = (int)Math.min((long)n2, this.remainingBytes);
                n4 = Math.min(n4, this.buffer.length - this.pos);
                System.arraycopy(this.buffer, this.pos, byArray, n, n4);
                this.pos += n4;
                n3 += n4;
                this.remainingBytes -= (long)n4;
                n += n4;
                n2 -= n4;
            }
            return n3 == 0 ? -1 : n3;
        }

        private void fillBuffer() throws IOException {
            if (this.buffer != null && this.pos < this.buffer.length) {
                return;
            }
            if (this.remainingBytes <= 0L) {
                return;
            }
            try {
                this.buffer = LobStorage.this.readBlock(this.lob, this.seq++);
                this.pos = 0;
            }
            catch (SQLException sQLException) {
                throw DbException.convertToIOException(sQLException);
            }
        }
    }
}

