/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2;

import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.Access;
import thredds.catalog2.AccessUriBuilder;

public class BasicAccessUriBuilder
implements AccessUriBuilder {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public URI buildAccessUri(Access access, URI docBaseUri) {
        if (access == null) {
            throw new IllegalArgumentException("Access must not be null.");
        }
        URI baseServiceUri = access.getService().getBaseUri();
        if (!baseServiceUri.isAbsolute()) {
            if (docBaseUri == null) {
                throw new IllegalStateException("Document base URI must not be null if service base URI is not absolute.");
            }
            baseServiceUri = docBaseUri.resolve(baseServiceUri);
        }
        StringBuilder sb = new StringBuilder(baseServiceUri.toString());
        sb.append(access.getUrlPath());
        String suffix = access.getService().getSuffix();
        if (suffix != null && !suffix.equals("")) {
            sb.append(suffix);
        }
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            this.log.error("buildAccessUri(): URI syntax exception [" + sb.toString() + "].", (Throwable)e);
            return null;
        }
    }
}

