/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.classify.SubclassClassifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.retry.ExhaustedRetryException;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RecoverAnnotationRecoveryHandler<T>
implements MethodInvocationRecoverer<T> {
    private SubclassClassifier<Throwable, Method> classifier = new SubclassClassifier();
    private Map<Method, SimpleMetadata> methods = new HashMap<Method, SimpleMetadata>();
    private Object target;
    private String recoverMethodName;

    public RecoverAnnotationRecoveryHandler(Object target, Method method) {
        this.target = target;
        this.init(target, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T recover(Object[] args, Throwable cause) {
        Method method = this.findClosestMatch(args, cause.getClass());
        if (method == null) {
            throw new ExhaustedRetryException("Cannot locate recovery method", cause);
        }
        SimpleMetadata meta = this.methods.get(method);
        Object[] argsToUse = meta.getArgs(cause, args);
        boolean methodAccessible = method.isAccessible();
        try {
            Object result;
            ReflectionUtils.makeAccessible((Method)method);
            Object object = result = ReflectionUtils.invokeMethod((Method)method, (Object)this.target, (Object[])argsToUse);
            return (T)object;
        }
        finally {
            if (methodAccessible != method.isAccessible()) {
                method.setAccessible(methodAccessible);
            }
        }
    }

    private Method findClosestMatch(Object[] args, Class<? extends Throwable> cause) {
        Method result = null;
        if (StringUtils.isEmpty((Object)this.recoverMethodName)) {
            int min = Integer.MAX_VALUE;
            for (Map.Entry<Method, SimpleMetadata> entry : this.methods.entrySet()) {
                boolean parametersMatch;
                Method method = entry.getKey();
                SimpleMetadata meta = entry.getValue();
                Class<? extends Throwable> type = meta.getType();
                if (type == null) {
                    type = Throwable.class;
                }
                if (!type.isAssignableFrom(cause)) continue;
                int distance = this.calculateDistance(cause, type);
                if (distance < min) {
                    min = distance;
                    result = method;
                    continue;
                }
                if (distance != min || !(parametersMatch = this.compareParameters(args, meta.getArgCount(), method.getParameterTypes()))) continue;
                result = method;
            }
        } else {
            for (Map.Entry<Method, SimpleMetadata> entry : this.methods.entrySet()) {
                SimpleMetadata meta;
                Method method = entry.getKey();
                if (!method.getName().equals(this.recoverMethodName) || !(meta = entry.getValue()).type.isAssignableFrom(cause) || !this.compareParameters(args, meta.getArgCount(), method.getParameterTypes())) continue;
                result = method;
                break;
            }
        }
        return result;
    }

    private int calculateDistance(Class<? extends Throwable> cause, Class<? extends Throwable> type) {
        int result = 0;
        for (Class<? extends Throwable> current = cause; current != type && current != Throwable.class; current = current.getSuperclass()) {
            ++result;
        }
        return result;
    }

    private boolean compareParameters(Object[] args, int argCount, Class<?>[] parameterTypes) {
        if (argCount == args.length + 1) {
            int startingIndex = 0;
            if (parameterTypes.length > 0 && Throwable.class.isAssignableFrom(parameterTypes[0])) {
                startingIndex = 1;
            }
            for (int i = startingIndex; i < parameterTypes.length; ++i) {
                Object argument;
                Object object = argument = i - startingIndex < args.length ? args[i - startingIndex] : null;
                if (argument == null || parameterTypes[i].isAssignableFrom(argument.getClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void init(final Object target, Method method) {
        final HashMap types = new HashMap();
        final Method failingMethod = method;
        Retryable retryable = (Retryable)AnnotationUtils.findAnnotation((Method)method, Retryable.class);
        if (retryable != null) {
            this.recoverMethodName = retryable.recover();
        }
        ReflectionUtils.doWithMethods(target.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Recover recover = (Recover)AnnotationUtils.findAnnotation((Method)method, Recover.class);
                if (recover == null) {
                    recover = RecoverAnnotationRecoveryHandler.this.findAnnotationOnTarget(target, method);
                }
                if (recover != null && method.getReturnType().isAssignableFrom(failingMethod.getReturnType())) {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length > 0 && Throwable.class.isAssignableFrom(parameterTypes[0])) {
                        Class<?> type = parameterTypes[0];
                        types.put(type, method);
                        RecoverAnnotationRecoveryHandler.this.methods.put(method, new SimpleMetadata(parameterTypes.length, type));
                    } else {
                        RecoverAnnotationRecoveryHandler.this.classifier.setDefaultValue(method);
                        RecoverAnnotationRecoveryHandler.this.methods.put(method, new SimpleMetadata(parameterTypes.length, null));
                    }
                }
            }
        });
        this.classifier.setTypeMap(types);
        this.optionallyFilterMethodsBy(failingMethod.getReturnType());
    }

    private Recover findAnnotationOnTarget(Object target, Method method) {
        try {
            Method targetMethod = target.getClass().getMethod(method.getName(), method.getParameterTypes());
            return (Recover)AnnotationUtils.findAnnotation((Method)targetMethod, Recover.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void optionallyFilterMethodsBy(Class<?> returnClass) {
        HashMap<Method, SimpleMetadata> filteredMethods = new HashMap<Method, SimpleMetadata>();
        for (Method method : this.methods.keySet()) {
            if (method.getReturnType() != returnClass) continue;
            filteredMethods.put(method, this.methods.get(method));
        }
        if (filteredMethods.size() > 0) {
            this.methods = filteredMethods;
        }
    }

    private static class SimpleMetadata {
        private int argCount;
        private Class<? extends Throwable> type;

        public SimpleMetadata(int argCount, Class<? extends Throwable> type) {
            this.argCount = argCount;
            this.type = type;
        }

        public int getArgCount() {
            return this.argCount;
        }

        public Class<? extends Throwable> getType() {
            return this.type;
        }

        public Object[] getArgs(Throwable t, Object[] args) {
            int length;
            Object[] result = new Object[this.getArgCount()];
            int startArgs = 0;
            if (this.type != null) {
                result[0] = t;
                startArgs = 1;
            }
            int n = length = result.length - startArgs > args.length ? args.length : result.length - startArgs;
            if (length == 0) {
                return result;
            }
            System.arraycopy(args, 0, result, startArgs, length);
            return result;
        }
    }
}

