/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.InvalidViewIdException;
import org.apache.myfaces.application.ViewHandlerSupport;

public class DefaultViewHandlerSupport
implements ViewHandlerSupport {
    private static final String CACHED_SERVLET_MAPPING = DefaultViewHandlerSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    private static final Log log = LogFactory.getLog(DefaultViewHandlerSupport.class);

    public String calculateViewId(FacesContext context, String viewId) {
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.applyDefaultSuffix(context, viewId);
        } else if (mapping != null && viewId != null && mapping.getUrlPattern().startsWith(viewId)) {
            throw new InvalidViewIdException(viewId);
        }
        return viewId;
    }

    public String calculateActionURL(FacesContext context, String viewId) {
        if (viewId == null || !viewId.startsWith("/")) {
            throw new IllegalArgumentException("ViewId must start with a '/': " + viewId);
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        ExternalContext externalContext = context.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        StringBuilder builder = new StringBuilder(contextPath);
        if (mapping != null) {
            if (mapping.isExtensionMapping()) {
                String contextSuffix = this.getContextSuffix(context);
                if (viewId.endsWith(contextSuffix)) {
                    builder.append(viewId.substring(0, viewId.indexOf(contextSuffix)));
                    builder.append(mapping.getExtension());
                } else {
                    builder.append(viewId);
                }
            } else {
                builder.append(mapping.getPrefix());
                builder.append(viewId);
            }
        } else {
            builder.append(viewId);
        }
        String calculatedActionURL = builder.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Calculated actionURL: '" + calculatedActionURL + "' for viewId: '" + viewId + "'"));
        }
        return calculatedActionURL;
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        if (!requestMap.containsKey(CACHED_SERVLET_MAPPING)) {
            ExternalContext externalContext = context.getExternalContext();
            FacesServletMapping mapping = DefaultViewHandlerSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            requestMap.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return (FacesServletMapping)requestMap.get(CACHED_SERVLET_MAPPING);
    }

    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    protected String getContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".jsp";
        }
        return defaultSuffix;
    }

    protected String applyDefaultSuffix(FacesContext context, String viewId) {
        String defaultSuffix = this.getContextSuffix(context);
        if (viewId == null) {
            return null;
        }
        if (!viewId.endsWith(defaultSuffix)) {
            StringBuilder builder = new StringBuilder(viewId);
            int slashPos = viewId.lastIndexOf(47);
            int extensionPos = viewId.lastIndexOf(46);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, viewId.length(), defaultSuffix);
            } else {
                builder.append(defaultSuffix);
            }
            viewId = builder.toString();
            if (log.isTraceEnabled()) {
                log.trace((Object)("view id after applying the context suffix: " + viewId));
            }
        }
        return viewId;
    }

    protected static class FacesServletMapping {
        private String prefix;
        private String extension;

        protected FacesServletMapping() {
        }

        public static FacesServletMapping createPrefixMapping(String path) {
            FacesServletMapping mapping = new FacesServletMapping();
            mapping.setPrefix(path);
            return mapping;
        }

        public static FacesServletMapping createExtensionMapping(String extension) {
            FacesServletMapping mapping = new FacesServletMapping();
            mapping.setExtension(extension);
            return mapping;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String path) {
            this.prefix = path;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public boolean isExtensionMapping() {
            return this.extension != null;
        }

        public String getUrlPattern() {
            if (this.isExtensionMapping()) {
                return "*" + this.extension;
            }
            return this.prefix + "/*";
        }
    }
}

