/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.myfaces.application.ApplicationFactoryImpl;
import org.apache.myfaces.application.BackwardsCompatibleNavigationHandlerWrapper;
import org.apache.myfaces.component.visit.VisitContextFactoryImpl;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.ManagedBeanDestroyer;
import org.apache.myfaces.config.NamedEventManager;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.AnnotationConfigurator;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.config.element.Behavior;
import org.apache.myfaces.config.element.ClientBehaviorRenderer;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesConfigData;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NamedEvent;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.config.element.SystemEventListener;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.context.ExceptionHandlerFactoryImpl;
import org.apache.myfaces.context.ExternalContextFactoryImpl;
import org.apache.myfaces.context.FacesContextFactoryImpl;
import org.apache.myfaces.context.PartialViewContextFactoryImpl;
import org.apache.myfaces.el.DefaultPropertyResolver;
import org.apache.myfaces.el.VariableResolverImpl;
import org.apache.myfaces.lifecycle.LifecycleFactoryImpl;
import org.apache.myfaces.renderkit.RenderKitFactoryImpl;
import org.apache.myfaces.renderkit.html.HtmlRenderKitImpl;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.LocaleUtils;
import org.apache.myfaces.shared_impl.util.serial.DefaultSerialFactory;
import org.apache.myfaces.shared_impl.util.serial.SerialFactory;
import org.apache.myfaces.spi.FacesConfigurationMerger;
import org.apache.myfaces.spi.FacesConfigurationMergerFactory;
import org.apache.myfaces.util.ContainerUtils;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.ViewDeclarationLanguageFactoryImpl;
import org.apache.myfaces.view.facelets.tag.jsf.TagHandlerDelegateFactoryImpl;
import org.apache.myfaces.view.facelets.tag.ui.DebugPhaseListener;
import org.apache.myfaces.webapp.ManagedBeanDestroyerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigurator {
    private static final Logger log = Logger.getLogger(FacesConfigurator.class.getName());
    private static final String DEFAULT_RENDER_KIT_CLASS = HtmlRenderKitImpl.class.getName();
    private static final String DEFAULT_APPLICATION_FACTORY = ApplicationFactoryImpl.class.getName();
    private static final String DEFAULT_EXTERNAL_CONTEXT_FACTORY = ExternalContextFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = FacesContextFactoryImpl.class.getName();
    private static final String DEFAULT_LIFECYCLE_FACTORY = LifecycleFactoryImpl.class.getName();
    private static final String DEFAULT_RENDER_KIT_FACTORY = RenderKitFactoryImpl.class.getName();
    private static final String DEFAULT_PARTIAL_VIEW_CONTEXT_FACTORY = PartialViewContextFactoryImpl.class.getName();
    private static final String DEFAULT_VISIT_CONTEXT_FACTORY = VisitContextFactoryImpl.class.getName();
    private static final String DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY = ViewDeclarationLanguageFactoryImpl.class.getName();
    private static final String DEFAULT_EXCEPTION_HANDLER_FACTORY = ExceptionHandlerFactoryImpl.class.getName();
    private static final String DEFAULT_TAG_HANDLER_DELEGATE_FACTORY = TagHandlerDelegateFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private final ExternalContext _externalContext;
    private FacesConfigUnmarshaller<? extends FacesConfig> _unmarshaller;
    private FacesConfigData _dispenser;
    private AnnotationConfigurator _annotationConfigurator;
    private RuntimeConfig _runtimeConfig;
    private static long lastUpdate;

    public FacesConfigurator(ExternalContext externalContext) {
        if (externalContext == null) {
            throw new IllegalArgumentException("external context must not be null");
        }
        this._externalContext = externalContext;
    }

    public void setUnmarshaller(FacesConfigUnmarshaller<? extends FacesConfig> unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller<? extends FacesConfig> getUnmarshaller() {
        if (this._unmarshaller == null) {
            this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(this._externalContext);
        }
        return this._unmarshaller;
    }

    public void setDispenser(FacesConfigData dispenser) {
        this._dispenser = dispenser;
    }

    protected FacesConfigData getDispenser() {
        if (this._dispenser == null) {
            this._dispenser = new DigesterFacesConfigDispenserImpl();
        }
        return this._dispenser;
    }

    public void setAnnotationConfigurator(AnnotationConfigurator configurator) {
        this._annotationConfigurator = configurator;
    }

    protected AnnotationConfigurator getAnnotationConfigurator() {
        if (this._annotationConfigurator == null) {
            this._annotationConfigurator = new AnnotationConfigurator();
        }
        return this._annotationConfigurator;
    }

    private long getResourceLastModified(String resource) {
        try {
            URL url = this._externalContext.getResource(resource);
            if (url != null) {
                return this.getResourceLastModified(url);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not read resource " + resource, e);
        }
        return 0L;
    }

    private long getResourceLastModified(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String externalForm = url.toExternalForm();
            File file = new File(externalForm.substring(5));
            return file.lastModified();
        }
        return this.getResourceLastModified(url.openConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getResourceLastModified(URLConnection connection) throws IOException {
        long modified;
        if (connection instanceof JarURLConnection) {
            URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
            URLConnection jarFileConnection = jarFileUrl.openConnection();
            try {
                modified = jarFileConnection.getLastModified();
            }
            finally {
                try {
                    jarFileConnection.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        modified = connection.getLastModified();
        return modified;
    }

    private long getLastModifiedTime() {
        long lastModified = 0L;
        long resModified = this.getResourceLastModified(DEFAULT_FACES_CONFIG);
        if (resModified > lastModified) {
            lastModified = resModified;
        }
        List<String> configFilesList = this.getConfigFilesList();
        int size = configFilesList.size();
        for (int i = 0; i < size; ++i) {
            String systemId = configFilesList.get(i);
            resModified = this.getResourceLastModified(systemId);
            if (resModified <= lastModified) continue;
            lastModified = resModified;
        }
        return lastModified;
    }

    public void update() {
        if (ContainerUtils.isRunningOnGoogleAppEngine(this._externalContext)) {
            return;
        }
        long refreshPeriod = MyfacesConfig.getCurrentInstance(this._externalContext).getConfigRefreshPeriod() * 1000L;
        if (refreshPeriod > 0L) {
            long ttl = lastUpdate + refreshPeriod;
            if (System.currentTimeMillis() > ttl && this.getLastModifiedTime() > ttl) {
                try {
                    this.purgeConfiguration();
                }
                catch (NoSuchMethodException e) {
                    log.severe("Configuration objects do not support clean-up. Update aborted");
                    lastUpdate = System.currentTimeMillis();
                    return;
                }
                catch (IllegalAccessException e) {
                    log.severe("Error during configuration clean-up" + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    log.severe("Error during configuration clean-up" + e.getMessage());
                }
                this.configure();
                FacesContext facesContext = FacesContext.getCurrentInstance();
                Application application = facesContext.getApplication();
                application.publishEvent(facesContext, PostConstructApplicationEvent.class, Application.class, application);
            }
        }
    }

    private void purgeConfiguration() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] NO_PARAMETER_TYPES = new Class[]{};
        Object[] NO_PARAMETERS = new Object[]{};
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        Method appFactoryPurgeMethod = applicationFactory.getClass().getMethod("purgeApplication", NO_PARAMETER_TYPES);
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        Method renderKitPurgeMethod = renderKitFactory.getClass().getMethod("purgeRenderKit", NO_PARAMETER_TYPES);
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        Method lifecyclePurgeMethod = lifecycleFactory.getClass().getMethod("purgeLifecycle", NO_PARAMETER_TYPES);
        appFactoryPurgeMethod.invoke((Object)applicationFactory, NO_PARAMETERS);
        renderKitPurgeMethod.invoke((Object)renderKitFactory, NO_PARAMETERS);
        RuntimeConfig.getCurrentInstance(this._externalContext).purge();
        lifecyclePurgeMethod.invoke((Object)lifecycleFactory, NO_PARAMETERS);
    }

    public void configure() throws FacesException {
        FacesConfigurationMerger facesConfigurationMerger = FacesConfigurationMergerFactory.getFacesConfigurationMergerFactory(this._externalContext).getFacesConfigurationMerger(this._externalContext);
        this.setDispenser(facesConfigurationMerger.getFacesConfigData(this._externalContext));
        this.configureFactories();
        this.configureApplication();
        this.configureRenderKits();
        this.configureRuntimeConfig();
        this.configureLifecycle();
        this.handleSerialFactory();
        this.configureManagedBeanDestroyer();
        lastUpdate = System.currentTimeMillis();
    }

    private List<String> getConfigFilesList() {
        String configFiles = this._externalContext.getInitParameter("javax.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.warning("/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See JSF spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void configureFactories() {
        FacesConfigData dispenser = this.getDispenser();
        this.setFactories("javax.faces.application.ApplicationFactory", dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("javax.faces.context.ExceptionHandlerFactory", dispenser.getExceptionHandlerFactoryIterator(), DEFAULT_EXCEPTION_HANDLER_FACTORY);
        this.setFactories("javax.faces.context.ExternalContextFactory", dispenser.getExternalContextFactoryIterator(), DEFAULT_EXTERNAL_CONTEXT_FACTORY);
        this.setFactories("javax.faces.context.FacesContextFactory", dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("javax.faces.lifecycle.LifecycleFactory", dispenser.getLifecycleFactoryIterator(), DEFAULT_LIFECYCLE_FACTORY);
        this.setFactories("javax.faces.render.RenderKitFactory", dispenser.getRenderKitFactoryIterator(), DEFAULT_RENDER_KIT_FACTORY);
        this.setFactories("javax.faces.view.facelets.TagHandlerDelegateFactory", dispenser.getTagHandlerDelegateFactoryIterator(), DEFAULT_TAG_HANDLER_DELEGATE_FACTORY);
        this.setFactories("javax.faces.context.PartialViewContextFactory", dispenser.getPartialViewContextFactoryIterator(), DEFAULT_PARTIAL_VIEW_CONTEXT_FACTORY);
        this.setFactories("javax.faces.component.visit.VisitContextFactory", dispenser.getVisitContextFactoryIterator(), DEFAULT_VISIT_CONTEXT_FACTORY);
        this.setFactories("javax.faces.view.ViewDeclarationLanguageFactory", dispenser.getViewDeclarationLanguageFactoryIterator(), DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY);
    }

    private void setFactories(String factoryName, Collection<String> factories, String defaultFactory) {
        FactoryFinder.setFactory(factoryName, defaultFactory);
        for (String factory : factories) {
            if (factory.equals(defaultFactory)) continue;
            FactoryFinder.setFactory(factoryName, factory);
        }
    }

    private void configureApplication() {
        Application application = ((ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory")).getApplication();
        FacesConfigData dispenser = this.getDispenser();
        application.setActionListener(ClassUtils.buildApplicationObject(ActionListener.class, dispenser.getActionListenerIterator(), null));
        if (dispenser.getDefaultLocale() != null) {
            application.setDefaultLocale(LocaleUtils.toLocale(dispenser.getDefaultLocale()));
        }
        if (dispenser.getDefaultRenderKitId() != null) {
            application.setDefaultRenderKitId(dispenser.getDefaultRenderKitId());
        }
        if (dispenser.getMessageBundle() != null) {
            application.setMessageBundle(dispenser.getMessageBundle());
        }
        application.setNavigationHandler(ClassUtils.buildApplicationObject(NavigationHandler.class, ConfigurableNavigationHandler.class, BackwardsCompatibleNavigationHandlerWrapper.class, dispenser.getNavigationHandlerIterator(), application.getNavigationHandler()));
        application.setStateManager(ClassUtils.buildApplicationObject(StateManager.class, dispenser.getStateManagerIterator(), application.getStateManager()));
        application.setResourceHandler(ClassUtils.buildApplicationObject(ResourceHandler.class, dispenser.getResourceHandlerIterator(), application.getResourceHandler()));
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String locale : dispenser.getSupportedLocalesIterator()) {
            locales.add(LocaleUtils.toLocale(locale));
        }
        application.setSupportedLocales(locales);
        application.setViewHandler(ClassUtils.buildApplicationObject(ViewHandler.class, dispenser.getViewHandlerIterator(), application.getViewHandler()));
        for (SystemEventListener systemEventListener : dispenser.getSystemEventListeners()) {
            try {
                Class eventClass = ClassUtils.classForName(systemEventListener.getSystemEventClass() != null ? systemEventListener.getSystemEventClass() : SystemEvent.class.getName());
                if (systemEventListener.getSourceClass() != null && systemEventListener.getSourceClass().length() > 0) {
                    application.subscribeToEvent(eventClass, ClassUtils.classForName(systemEventListener.getSourceClass()), (javax.faces.event.SystemEventListener)ClassUtils.newInstance(systemEventListener.getSystemEventListenerClass()));
                    continue;
                }
                application.subscribeToEvent(eventClass, (javax.faces.event.SystemEventListener)ClassUtils.newInstance(systemEventListener.getSystemEventListenerClass()));
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, "System event listener could not be initialized, reason:", e);
            }
        }
        for (String componentType : dispenser.getComponentTypes()) {
            application.addComponent(componentType, dispenser.getComponentClass(componentType));
        }
        for (String converterId : dispenser.getConverterIds()) {
            application.addConverter(converterId, dispenser.getConverterClassById(converterId));
        }
        for (String converterClass : dispenser.getConverterClasses()) {
            try {
                application.addConverter(ClassUtils.simpleClassForName(converterClass), dispenser.getConverterClassByClass(converterClass));
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Converter could not be added. Reason:", ex);
            }
        }
        for (String validatorId : dispenser.getValidatorIds()) {
            application.addValidator(validatorId, dispenser.getValidatorClass(validatorId));
        }
        String beanValidatorDisabled = this._externalContext.getInitParameter("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR");
        boolean defaultBeanValidatorDisabled = beanValidatorDisabled != null && beanValidatorDisabled.toLowerCase().equals("true");
        boolean beanValidatorInstalledProgrammatically = false;
        if (!defaultBeanValidatorDisabled && ExternalSpecifications.isBeanValidationAvailable()) {
            application.addDefaultValidatorId("javax.faces.Bean");
            beanValidatorInstalledProgrammatically = true;
        }
        for (String validatorId : dispenser.getDefaultValidatorIds()) {
            application.addDefaultValidatorId(validatorId);
        }
        if (!beanValidatorInstalledProgrammatically && application.getDefaultValidatorInfo().containsKey("javax.faces.Bean")) {
            if (!ExternalSpecifications.isBeanValidationAvailable()) {
                log.log(Level.WARNING, "The BeanValidator was installed as a default-validator from a faces-config file, but bean validation is not available on the classpath, thus it will not work!");
            } else if (defaultBeanValidatorDisabled) {
                log.log(Level.INFO, "The BeanValidator was disabled as a default-validator via the config parameter javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR in web.xml, but a faces-config file added it, thus it actually was installed as a default-validator.");
            }
        }
        for (Behavior behavior : dispenser.getBehaviors()) {
            application.addBehavior(behavior.getBehaviorId(), behavior.getBehaviorClass());
        }
        RuntimeConfig runtimeConfig = this.getRuntimeConfig();
        if (MyfacesConfig.getCurrentInstance(this._externalContext).isSupportJSPAndFacesEL()) {
            runtimeConfig.setPropertyResolverChainHead(ClassUtils.buildApplicationObject(PropertyResolver.class, dispenser.getPropertyResolverIterator(), new DefaultPropertyResolver()));
            runtimeConfig.setVariableResolverChainHead(ClassUtils.buildApplicationObject(VariableResolver.class, dispenser.getVariableResolverIterator(), new VariableResolverImpl()));
        }
    }

    String getDefaultSourcClassForSystemEvent(Class systemEventClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constr : constructors = systemEventClass.getConstructors()) {
            Class<?>[] parms = constr.getParameterTypes();
            if (parms == null || parms.length != 1) continue;
            return parms[0].getName();
        }
        log.warning("The SystemEvent source type for " + systemEventClass.getName() + " could not be detected, either register it manually or use a constructor argument " + "for auto detection, defaulting now to java.lang.Object");
        return "java.lang.Object";
    }

    protected RuntimeConfig getRuntimeConfig() {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        }
        return this._runtimeConfig;
    }

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this._runtimeConfig = runtimeConfig;
    }

    private void configureRuntimeConfig() {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        FacesConfigData dispenser = this.getDispenser();
        for (ManagedBean bean : dispenser.getManagedBeans()) {
            if (log.isLoggable(Level.WARNING) && runtimeConfig.getManagedBean(bean.getManagedBeanName()) != null) {
                log.warning("More than one managed bean w/ the name of '" + bean.getManagedBeanName() + "' - only keeping the last ");
            }
            runtimeConfig.addManagedBean(bean.getManagedBeanName(), bean);
        }
        this.removePurgedBeansFromSessionAndApplication(runtimeConfig);
        for (NavigationRule rule : dispenser.getNavigationRules()) {
            runtimeConfig.addNavigationRule(rule);
        }
        for (String converterClassName : dispenser.getConverterConfigurationByClassName()) {
            runtimeConfig.addConverterConfiguration(converterClassName, this._dispenser.getConverterConfiguration(converterClassName));
        }
        for (ResourceBundle bundle : dispenser.getResourceBundles()) {
            runtimeConfig.addResourceBundle(bundle);
        }
        for (String className : dispenser.getElResolvers()) {
            runtimeConfig.addFacesConfigElResolver((ELResolver)ClassUtils.newInstance(className, ELResolver.class));
        }
        runtimeConfig.setFacesVersion(dispenser.getFacesVersion());
        runtimeConfig.setNamedEventManager(new NamedEventManager());
        for (NamedEvent event : dispenser.getNamedEvents()) {
            try {
                Class clazz = ClassUtils.classForName(event.getEventClass());
                runtimeConfig.getNamedEventManager().addNamedEvent(event.getShortName(), clazz);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, "Named event could not be initialized, reason:", e);
            }
        }
        String comparatorClass = this._externalContext.getInitParameter("org.apache.myfaces.EL_RESOLVER_COMPARATOR");
        if (comparatorClass != null && !"".equals(comparatorClass)) {
            try {
                Class clazz = ClassUtils.classForName(comparatorClass);
                Comparator comparator = (Comparator)clazz.newInstance();
                runtimeConfig.setELResolverComparator(comparator);
            }
            catch (Exception e) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, "Cannot instantiate EL Resolver Comparator " + comparatorClass + " . Check org.apache.myfaces.EL_RESOLVER_COMPARATOR web config param. " + "Initialization continues with no comparator used.", e);
                }
            }
        } else {
            runtimeConfig.setELResolverComparator(null);
        }
    }

    private void removePurgedBeansFromSessionAndApplication(RuntimeConfig runtimeConfig) {
        Map<String, ManagedBean> oldManagedBeans = runtimeConfig.getManagedBeansNotReaddedAfterPurge();
        if (oldManagedBeans != null) {
            for (Map.Entry<String, ManagedBean> entry : oldManagedBeans.entrySet()) {
                ManagedBean bean = entry.getValue();
                String scope = bean.getManagedBeanScope();
                if (scope != null && scope.equalsIgnoreCase("session")) {
                    this._externalContext.getSessionMap().remove(entry.getKey());
                    continue;
                }
                if (scope == null || !scope.equalsIgnoreCase("application")) continue;
                this._externalContext.getApplicationMap().remove(entry.getKey());
            }
        }
        runtimeConfig.resetManagedBeansNotReaddedAfterPurge();
    }

    private void configureRenderKits() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        FacesConfigData dispenser = this.getDispenser();
        for (String renderKitId : dispenser.getRenderKitIds()) {
            Collection<String> renderKitClass = dispenser.getRenderKitClasses(renderKitId);
            if (renderKitClass.isEmpty()) {
                renderKitClass = new ArrayList<String>(1);
                renderKitClass.add(DEFAULT_RENDER_KIT_CLASS);
            }
            RenderKit renderKit = ClassUtils.buildApplicationObject(RenderKit.class, renderKitClass, null);
            for (Renderer element : dispenser.getRenderers(renderKitId)) {
                javax.faces.render.Renderer renderer;
                try {
                    renderer = (javax.faces.render.Renderer)ClassUtils.newInstance(element.getRendererClass());
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "failed to configure class " + element.getRendererClass(), e);
                    continue;
                }
                renderKit.addRenderer(element.getComponentFamily(), element.getRendererType(), renderer);
            }
            Collection<ClientBehaviorRenderer> clientBehaviorRenderers = dispenser.getClientBehaviorRenderers(renderKitId);
            for (ClientBehaviorRenderer clientBehaviorRenderer : clientBehaviorRenderers) {
                try {
                    javax.faces.render.ClientBehaviorRenderer behaviorRenderer = (javax.faces.render.ClientBehaviorRenderer)ClassUtils.newInstance(clientBehaviorRenderer.getRendererClass());
                    renderKit.addClientBehaviorRenderer(clientBehaviorRenderer.getRendererType(), behaviorRenderer);
                }
                catch (Throwable e) {
                    if (!log.isLoggable(Level.SEVERE)) continue;
                    log.log(Level.SEVERE, "failed to configure client behavior renderer class " + clientBehaviorRenderer.getRendererClass(), e);
                }
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    private void configureLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        Iterator<String> it = lifecycleFactory.getLifecycleIds();
        while (it.hasNext()) {
            Lifecycle lifecycle = lifecycleFactory.getLifecycle(it.next());
            for (String listenerClassName : this.getDispenser().getLifecyclePhaseListeners()) {
                try {
                    lifecycle.addPhaseListener((PhaseListener)ClassUtils.newInstance(listenerClassName, PhaseListener.class));
                }
                catch (ClassCastException e) {
                    log.severe("Class " + listenerClassName + " does not implement PhaseListener");
                }
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!facesContext.isProjectStage(ProjectStage.Development) || !MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isDebugPhaseListenerEnabled()) continue;
            lifecycle.addPhaseListener(new DebugPhaseListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSerialFactory() {
        String serialProvider = this._externalContext.getInitParameter("org.apache.myfaces.SERIAL_FACTORY");
        SerialFactory serialFactory = null;
        if (serialProvider == null) {
            serialFactory = new DefaultSerialFactory();
        } else {
            try {
                serialFactory = (SerialFactory)ClassUtils.newInstance(serialProvider);
            }
            catch (ClassCastException e) {
                log.log(Level.SEVERE, "Make sure '" + serialProvider + "' implements the correct interface", e);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", e);
            }
            finally {
                if (serialFactory == null) {
                    serialFactory = new DefaultSerialFactory();
                    log.severe("Using default serialization provider");
                }
            }
        }
        log.info("Serialization provider : " + serialFactory.getClass());
        this._externalContext.getApplicationMap().put("org.apache.myfaces.SERIAL_FACTORY", serialFactory);
    }

    private void configureManagedBeanDestroyer() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map<String, Object> applicationMap = externalContext.getApplicationMap();
        Application application = facesContext.getApplication();
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        LifecycleProvider lifecycleProvider = LifecycleProviderFactory.getLifecycleProviderFactory(externalContext).getLifecycleProvider(externalContext);
        ManagedBeanDestroyer mbDestroyer = new ManagedBeanDestroyer(lifecycleProvider, runtimeConfig);
        application.subscribeToEvent(PreDestroyCustomScopeEvent.class, mbDestroyer);
        application.subscribeToEvent(PreDestroyViewMapEvent.class, mbDestroyer);
        ManagedBeanDestroyerListener listener = (ManagedBeanDestroyerListener)applicationMap.get("org.apache.myfaces.ManagedBeanDestroyerListener");
        if (listener != null) {
            listener.setManagedBeanDestroyer(mbDestroyer);
        } else {
            log.log(Level.SEVERE, "No ManagedBeanDestroyerListener instance found, thus @PreDestroy methods won't get called in every case. This instance needs to be published before configuration is started.");
        }
    }
}

