/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.net.MalformedURLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.lifecycle.RestoreViewSupport;
import org.apache.myfaces.shared.application.FacesServletMapping;
import org.apache.myfaces.shared.application.InvalidViewIdException;
import org.apache.myfaces.shared.util.Assert;
import org.apache.myfaces.shared.util.ConcurrentLRUCache;
import org.apache.myfaces.shared.util.ExternalContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRestoreViewSupport
implements RestoreViewSupport {
    private static final String JAVAX_SERVLET_INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static final String JAVAX_SERVLET_INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    private static final String PORTLET_LIFECYCLE_PHASE = "javax.portlet.faces.phase";
    private static final String CACHED_SERVLET_MAPPING = DefaultRestoreViewSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    private final Logger log = Logger.getLogger(DefaultRestoreViewSupport.class.getName());
    private static final String CHECKED_VIEWID_CACHE_SIZE_ATTRIBUTE = "org.apache.myfaces.CHECKED_VIEWID_CACHE_SIZE";
    private static final int CHECKED_VIEWID_CACHE_DEFAULT_SIZE = 500;
    private static final String CHECKED_VIEWID_CACHE_ENABLED_ATTRIBUTE = "org.apache.myfaces.CHECKED_VIEWID_CACHE_ENABLED";
    private static final boolean CHECKED_VIEWID_CACHE_ENABLED_DEFAULT = true;
    private static final String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private volatile ConcurrentLRUCache<String, Boolean> _checkedViewIdMap = null;
    private Boolean _checkedViewIdCacheEnabled = null;
    private RenderKitFactory _renderKitFactory = null;
    private VisitContextFactory _visitContextFactory = null;
    private final String[] _faceletsViewMappings;
    private final String[] _contextSuffixes;
    private final String _faceletsContextSufix;
    private final boolean _initialized;

    public DefaultRestoreViewSupport() {
        this._faceletsViewMappings = null;
        this._contextSuffixes = null;
        this._faceletsContextSufix = null;
        this._initialized = false;
    }

    public DefaultRestoreViewSupport(FacesContext facesContext) {
        this._faceletsViewMappings = this.getFaceletsViewMappings(facesContext);
        this._contextSuffixes = this.getContextSuffix(facesContext);
        this._faceletsContextSufix = this.getFaceletsContextSuffix(facesContext);
        this._initialized = true;
    }

    @Override
    public void processComponentBinding(FacesContext facesContext, UIComponent component) {
        facesContext.getAttributes().put(SKIP_ITERATION_HINT, Boolean.TRUE);
        VisitContext visitContext = this.getVisitContextFactory().getVisitContext(facesContext, null, null);
        component.visitTree(visitContext, (VisitCallback)new RestoreStateCallback());
        facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
    }

    @Override
    public String calculateViewId(FacesContext facesContext) {
        Assert.notNull(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        String viewId = null;
        boolean traceEnabled = this.log.isLoggable(Level.FINEST);
        if (requestMap.containsKey(PORTLET_LIFECYCLE_PHASE)) {
            viewId = externalContext.getRequestPathInfo();
        } else {
            viewId = (String)requestMap.get(JAVAX_SERVLET_INCLUDE_PATH_INFO);
            if (viewId != null) {
                if (traceEnabled) {
                    this.log.finest("Calculated viewId '" + viewId + "' from request param '" + JAVAX_SERVLET_INCLUDE_PATH_INFO + "'");
                }
            } else {
                viewId = externalContext.getRequestPathInfo();
                if (viewId != null && traceEnabled) {
                    this.log.finest("Calculated viewId '" + viewId + "' from request path info");
                }
            }
            if (viewId == null && (viewId = (String)requestMap.get(JAVAX_SERVLET_INCLUDE_SERVLET_PATH)) != null && traceEnabled) {
                this.log.finest("Calculated viewId '" + viewId + "' from request param '" + JAVAX_SERVLET_INCLUDE_SERVLET_PATH + "'");
            }
        }
        if (viewId == null && (viewId = externalContext.getRequestServletPath()) != null && traceEnabled) {
            this.log.finest("Calculated viewId '" + viewId + "' from request servlet path");
        }
        if (viewId == null) {
            throw new FacesException("Could not determine view id.");
        }
        return viewId;
    }

    @Override
    public boolean isPostback(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String renderkitId = viewHandler.calculateRenderKitId(facesContext);
        ResponseStateManager rsm = this.getRenderKitFactory().getRenderKit(facesContext, renderkitId).getResponseStateManager();
        return rsm.isPostback(facesContext);
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }

    protected VisitContextFactory getVisitContextFactory() {
        if (this._visitContextFactory == null) {
            this._visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"javax.faces.component.visit.VisitContextFactory");
        }
        return this._visitContextFactory;
    }

    @Override
    public String deriveViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.handleSuffixMapping(context, viewId);
        } else if (mapping.isPrefixMapping()) {
            if ((viewId = this.handlePrefixMapping(viewId, mapping.getPrefix())) != null && viewId.equals(mapping.getPrefix()) && !ExternalContextUtils.isPortlet(context.getExternalContext())) {
                throw new InvalidViewIdException();
            }
        } else if (viewId != null && mapping.getUrlPattern().startsWith(viewId)) {
            throw new InvalidViewIdException(viewId);
        }
        return viewId;
    }

    protected String[] getContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml .jsp";
        }
        return defaultSuffix.split(" ");
    }

    protected String getFaceletsContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.FACELETS_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml";
        }
        return defaultSuffix;
    }

    protected String[] getFaceletsViewMappings(FacesContext context) {
        String faceletsViewMappings = context.getExternalContext().getInitParameter("javax.faces.FACELETS_VIEW_MAPPINGS");
        if (faceletsViewMappings == null) {
            faceletsViewMappings = context.getExternalContext().getInitParameter("facelets.VIEW_MAPPINGS");
        }
        return faceletsViewMappings == null ? null : faceletsViewMappings.split(";");
    }

    protected String handlePrefixMapping(String viewId, String prefix) {
        String uri = viewId;
        prefix = "".equals(prefix) ? "//" : prefix + '/';
        while (uri.startsWith(prefix) || uri.startsWith("//")) {
            if (uri.startsWith(prefix)) {
                uri = uri.substring(prefix.length() - 1);
                continue;
            }
            uri = uri.substring(1);
        }
        return uri;
    }

    protected String handleSuffixMapping(FacesContext context, String requestViewId) {
        String faceletsDefaultSuffix;
        String[] faceletsViewMappings = this._initialized ? this._faceletsViewMappings : this.getFaceletsViewMappings(context);
        String[] jspDefaultSuffixes = this._initialized ? this._contextSuffixes : this.getContextSuffix(context);
        int slashPos = requestViewId.lastIndexOf(47);
        int extensionPos = requestViewId.lastIndexOf(46);
        for (String defaultSuffix : jspDefaultSuffixes) {
            StringBuilder builder = new StringBuilder(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), defaultSuffix);
            } else {
                builder.append(defaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (faceletsViewMappings != null && faceletsViewMappings.length > 0) {
                for (String mapping : faceletsViewMappings) {
                    if (mapping.startsWith("/")) continue;
                    if (mapping.equals(candidateViewId)) {
                        return candidateViewId;
                    }
                    if (!mapping.startsWith(".")) continue;
                    builder.setLength(0);
                    builder.append(candidateViewId);
                    builder.replace(candidateViewId.lastIndexOf(46), candidateViewId.length(), mapping);
                    String tempViewId = builder.toString();
                    if (!this.checkResourceExists(context, tempViewId)) continue;
                    return tempViewId;
                }
            }
            if (!this.checkResourceExists(context, candidateViewId)) continue;
            return candidateViewId;
        }
        String string = faceletsDefaultSuffix = this._initialized ? this._faceletsContextSufix : this.getFaceletsContextSuffix(context);
        if (faceletsDefaultSuffix != null) {
            for (String defaultSuffix : jspDefaultSuffixes) {
                if (!faceletsDefaultSuffix.equals(defaultSuffix)) continue;
                faceletsDefaultSuffix = null;
                break;
            }
        }
        if (faceletsDefaultSuffix != null) {
            StringBuilder builder = new StringBuilder(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), faceletsDefaultSuffix);
            } else {
                builder.append(faceletsDefaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (this.checkResourceExists(context, candidateViewId)) {
                return candidateViewId;
            }
        }
        if (this.checkResourceExists(context, requestViewId)) {
            return requestViewId;
        }
        return null;
    }

    protected boolean checkResourceExists(FacesContext context, String viewId) {
        try {
            if (this.isCheckedViewIdCachingEnabled(context)) {
                Boolean resourceExists = this.getCheckedViewIDMap(context).get(viewId);
                if (resourceExists == null) {
                    resourceExists = context.getExternalContext().getResource(viewId) != null;
                    this.getCheckedViewIDMap(context).put(viewId, resourceExists);
                }
                return resourceExists;
            }
            if (context.getExternalContext().getResource(viewId) != null) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = DefaultRestoreViewSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    private ConcurrentLRUCache<String, Boolean> getCheckedViewIDMap(FacesContext context) {
        if (this._checkedViewIdMap == null) {
            int maxSize = this.getViewIDCacheMaxSize(context);
            this._checkedViewIdMap = new ConcurrentLRUCache((maxSize * 4 + 3) / 3, maxSize);
        }
        return this._checkedViewIdMap;
    }

    private boolean isCheckedViewIdCachingEnabled(FacesContext context) {
        if (this._checkedViewIdCacheEnabled == null) {
            if (!context.isProjectStage(ProjectStage.Production)) {
                this._checkedViewIdCacheEnabled = Boolean.FALSE;
                return this._checkedViewIdCacheEnabled;
            }
            String configParam = context.getExternalContext().getInitParameter(CHECKED_VIEWID_CACHE_ENABLED_ATTRIBUTE);
            this._checkedViewIdCacheEnabled = configParam == null ? true : Boolean.parseBoolean(configParam);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "MyFaces ViewID Caching Enabled=" + this._checkedViewIdCacheEnabled);
            }
        }
        return this._checkedViewIdCacheEnabled;
    }

    private int getViewIDCacheMaxSize(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String configParam = externalContext == null ? null : externalContext.getInitParameter(CHECKED_VIEWID_CACHE_SIZE_ATTRIBUTE);
        return configParam == null ? 500 : Integer.parseInt(configParam);
    }

    private static class RestoreStateCallback
    implements VisitCallback {
        private PostRestoreStateEvent event;

        private RestoreStateCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (this.event == null) {
                this.event = new PostRestoreStateEvent(target);
            } else {
                this.event.setComponent(target);
            }
            target.processEvent((ComponentSystemEvent)this.event);
            return VisitResult.ACCEPT;
        }
    }
}

