/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.myfaces.application.viewstate.KeyFactory;
import org.apache.myfaces.application.viewstate.SessionIdGenerator;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecureRandomKeyFactory
extends KeyFactory<byte[]> {
    private final SessionIdGenerator sessionIdGenerator;
    private final int length;

    public SecureRandomKeyFactory(FacesContext facesContext) {
        String secureRandomAlgorithm;
        String secureRandomProvider;
        this.length = WebConfigParamUtils.getIntegerInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH", 8);
        this.sessionIdGenerator = new SessionIdGenerator();
        this.sessionIdGenerator.setSessionIdLength(this.length);
        String secureRandomClass = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS");
        if (secureRandomClass != null) {
            this.sessionIdGenerator.setSecureRandomClass(secureRandomClass);
        }
        if ((secureRandomProvider = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER")) != null) {
            this.sessionIdGenerator.setSecureRandomProvider(secureRandomProvider);
        }
        if ((secureRandomAlgorithm = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITM")) != null) {
            this.sessionIdGenerator.setSecureRandomAlgorithm(secureRandomAlgorithm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer generateCounterKey(FacesContext facesContext) {
        Integer sequence;
        Object sessionObj;
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = sessionObj = externalContext.getSession(true);
        synchronized (object) {
            Map<String, Object> map = externalContext.getSessionMap();
            sequence = (Integer)map.get("jsf_sequence");
            sequence = sequence == null || sequence == Integer.MAX_VALUE ? Integer.valueOf(1) : Integer.valueOf(sequence + 1);
            map.put("jsf_sequence", sequence);
        }
        return sequence;
    }

    @Override
    public byte[] generateKey(FacesContext facesContext) {
        byte[] array = new byte[this.length];
        byte[] key = new byte[this.length + 4];
        this.sessionIdGenerator.getRandomBytes(array);
        for (int i = 0; i < array.length; ++i) {
            key[i] = array[i];
        }
        int value = this.generateCounterKey(facesContext);
        key[array.length] = (byte)(value >>> 24);
        key[array.length + 1] = (byte)(value >>> 16);
        key[array.length + 2] = (byte)(value >>> 8);
        key[array.length + 3] = (byte)value;
        return key;
    }

    @Override
    public String encode(byte[] key) {
        return new String(Hex.encodeHex((byte[])key));
    }

    @Override
    public byte[] decode(String value) {
        try {
            return Hex.decodeHex((char[])value.toCharArray());
        }
        catch (DecoderException decoderException) {
            return null;
        }
    }
}

