/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.application.StateCache;
import org.apache.myfaces.application.StateCacheFactory;
import org.apache.myfaces.application.viewstate.StateCacheFactoryImpl;
import org.apache.myfaces.renderkit.MyfacesResponseStateManager;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.util.StateUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public class HtmlResponseStateManager
extends MyfacesResponseStateManager {
    private static final Logger log = Logger.getLogger(HtmlResponseStateManager.class.getName());
    private static final int STATE_PARAM = 0;
    private static final int VIEWID_PARAM = 1;
    public static final String STANDARD_STATE_SAVING_PARAM = "javax.faces.ViewState";
    public static final String INIT_PARAM_HANDLE_STATE_CACHING_MECHANICS = "org.apache.myfaces.HANDLE_STATE_CACHING_MECHANICS";
    public static final String INIT_PARAM_AUTOCOMPLETE_OFF_VIEW_STATE = "org.apache.myfaces.AUTOCOMPLETE_OFF_VIEW_STATE";
    private Boolean _handleStateCachingMechanics;
    private StateCacheFactory _stateCacheFactory = new StateCacheFactoryImpl();
    private Boolean _autoCompleteOffViewState = null;

    protected boolean isHandlingStateCachingMechanics(FacesContext facesContext) {
        if (this._handleStateCachingMechanics == null) {
            this._handleStateCachingMechanics = WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), INIT_PARAM_HANDLE_STATE_CACHING_MECHANICS, true);
        }
        return this._handleStateCachingMechanics;
    }

    public void writeState(FacesContext facesContext, Object state) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Object[] savedStateObject = null;
        if (this.isHandlingStateCachingMechanics(facesContext)) {
            savedStateObject = (Object[])this.getStateCache(facesContext).encodeSerializedState(facesContext, state);
        } else {
            Object token = null;
            Object[] savedState = new Object[2];
            token = state;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Writing state in client");
            }
            if (token != null) {
                savedState[0] = token;
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("No component states to be saved in client response!");
            }
            savedState[1] = facesContext.getViewRoot().getViewId();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Writing view state and renderKit fields");
            }
            savedStateObject = savedState;
        }
        this.writeViewStateField(facesContext, responseWriter, savedStateObject);
        this.writeRenderKitIdField(facesContext, responseWriter);
    }

    public void saveState(FacesContext facesContext, Object state) {
        if (this.isHandlingStateCachingMechanics(facesContext)) {
            this.getStateCache(facesContext).saveSerializedView(facesContext, state);
        }
    }

    private void writeViewStateField(FacesContext facesContext, ResponseWriter responseWriter, Object savedState) throws IOException {
        String serializedState = StateUtils.construct(savedState, facesContext.getExternalContext());
        ExternalContext extContext = facesContext.getExternalContext();
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(extContext);
        if (JavascriptUtils.isJavascriptAllowed(extContext) && myfacesConfig.isViewStateJavascript()) {
            HtmlRendererUtils.renderViewStateJavascript(facesContext, STANDARD_STATE_SAVING_PARAM, serializedState);
        } else {
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", "hidden", null);
            responseWriter.writeAttribute("name", STANDARD_STATE_SAVING_PARAM, null);
            if (myfacesConfig.isRenderViewStateId()) {
                responseWriter.writeAttribute("id", STANDARD_STATE_SAVING_PARAM, null);
            }
            responseWriter.writeAttribute("value", serializedState, null);
            if (this.isAutocompleteOffViewState(facesContext)) {
                responseWriter.writeAttribute("autocomplete", "off", null);
            }
            responseWriter.endElement("input");
        }
    }

    private void writeRenderKitIdField(FacesContext facesContext, ResponseWriter responseWriter) throws IOException {
        String defaultRenderKitId = facesContext.getApplication().getDefaultRenderKitId();
        if (defaultRenderKitId != null && !"HTML_BASIC".equals(defaultRenderKitId)) {
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", "hidden", null);
            responseWriter.writeAttribute("name", "javax.faces.RenderKitId", null);
            responseWriter.writeAttribute("value", defaultRenderKitId, null);
            responseWriter.endElement("input");
        }
    }

    public Object getState(FacesContext facesContext, String viewId) {
        Object savedState = this.getSavedState(facesContext);
        if (savedState == null) {
            return null;
        }
        if (this.isHandlingStateCachingMechanics(facesContext)) {
            return this.getStateCache(facesContext).restoreSerializedView(facesContext, viewId, savedState);
        }
        return ((Object[])savedState)[0];
    }

    private Object getSavedState(FacesContext facesContext) {
        String encodedState = facesContext.getExternalContext().getRequestParameterMap().get(STANDARD_STATE_SAVING_PARAM);
        if (encodedState == null || encodedState.length() == 0) {
            return null;
        }
        Object savedStateObject = StateUtils.reconstruct(encodedState, facesContext.getExternalContext());
        if (this.isHandlingStateCachingMechanics(facesContext)) {
            return savedStateObject;
        }
        Object[] savedState = (Object[])savedStateObject;
        if (savedState == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("No saved state");
            }
            return null;
        }
        String restoredViewId = (String)savedState[1];
        if (restoredViewId == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("No saved state or state of a different viewId: " + restoredViewId);
            }
            return null;
        }
        return savedState;
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(STANDARD_STATE_SAVING_PARAM);
    }

    public String getViewState(FacesContext facesContext, Object baseState) {
        if (baseState == null) {
            return null;
        }
        Object[] state = null;
        if (this.isHandlingStateCachingMechanics(facesContext)) {
            state = (Object[])this.getStateCache(facesContext).saveSerializedView(facesContext, baseState);
        } else {
            Object[] savedState = new Object[2];
            if (state != null) {
                savedState[0] = baseState;
            }
            savedState[1] = facesContext.getViewRoot().getViewId();
            state = savedState;
        }
        return StateUtils.construct(state, facesContext.getExternalContext());
    }

    public boolean isWriteStateAfterRenderViewRequired(FacesContext facesContext) {
        return this.getStateCache(facesContext).isWriteStateAfterRenderViewRequired(facesContext);
    }

    protected StateCache getStateCache(FacesContext facesContext) {
        return this._stateCacheFactory.getStateCache(facesContext);
    }

    private boolean isAutocompleteOffViewState(FacesContext facesContext) {
        if (this._autoCompleteOffViewState == null) {
            this._autoCompleteOffViewState = WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), INIT_PARAM_AUTOCOMPLETE_OFF_VIEW_STATE, true);
        }
        return this._autoCompleteOffViewState;
    }
}

