/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.shared.util.ArrayUtils;
import org.apache.myfaces.shared.util.StringUtils;

public class HtmlGridRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlGridRendererBase.class.getName());
    private static final Integer[] ZERO_INT_ARRAY = new Integer[]{0};

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        int columns;
        RendererUtils.checkParamValidity(facesContext, component, UIPanel.class);
        if (component instanceof HtmlPanelGrid) {
            columns = ((HtmlPanelGrid)component).getColumns();
        } else {
            Integer i = (Integer)component.getAttributes().get("columns");
            int n = columns = i != null ? i : 0;
        }
        if (columns <= 0) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("Wrong columns attribute for PanelGrid " + component.getClientId(facesContext) + ": " + columns);
            }
            columns = 1;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement("table", component);
        if (component instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            if (!behaviors.isEmpty()) {
                HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
            }
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, component);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, CommonEventUtils.getCommonEventsMarked(component), component, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_ATTRIBUTES);
                CommonPropertyUtils.renderCommonPassthroughPropertiesWithoutEvents(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_ATTRIBUTES);
                CommonPropertyUtils.renderCommonPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
            }
        }
        writer.flush();
        HtmlRendererUtils.renderTableCaption(facesContext, writer, component);
        this.renderHeaderOrFooter(facesContext, writer, component, columns, true);
        this.renderHeaderOrFooter(facesContext, writer, component, columns, false);
        this.renderChildren(facesContext, writer, component, columns);
        writer.endElement("table");
    }

    protected void renderHeaderOrFooter(FacesContext context, ResponseWriter writer, UIComponent component, int columns, boolean header) throws IOException {
        String styleClass;
        UIComponent facet = component.getFacet(header ? "header" : "footer");
        if (facet == null) {
            return;
        }
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.startElement(header ? "thead" : "tfoot", component);
        writer.startElement("tr", component);
        writer.startElement(header ? "th" : "td", component);
        String string = component instanceof HtmlPanelGrid ? (header ? ((HtmlPanelGrid)component).getHeaderClass() : ((HtmlPanelGrid)component).getFooterClass()) : (styleClass = header ? (String)component.getAttributes().get("headerClass") : (String)component.getAttributes().get("footerClass"));
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, header ? "headerClass" : "footerClass");
        }
        if (header) {
            writer.writeAttribute("scope", (Object)"colgroup", null);
        }
        writer.writeAttribute("colspan", (Object)Integer.toString(columns), null);
        HtmlRendererUtils.writePrettyLineSeparator(context);
        facet.encodeAll(context);
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.endElement(header ? "th" : "td");
        writer.endElement("tr");
        writer.endElement(header ? "thead" : "tfoot");
    }

    protected int childAttributes(FacesContext context, ResponseWriter writer, UIComponent component, int columnIndex) throws IOException {
        return columnIndex;
    }

    protected void renderChildren(FacesContext context, ResponseWriter writer, UIComponent component, int columns) throws IOException {
        String rowClasses;
        String columnClasses;
        if (component instanceof HtmlPanelGrid) {
            columnClasses = ((HtmlPanelGrid)component).getColumnClasses();
            rowClasses = ((HtmlPanelGrid)component).getRowClasses();
        } else {
            columnClasses = (String)component.getAttributes().get("columnClasses");
            rowClasses = (String)component.getAttributes().get("rowClasses");
        }
        String[] columnClassesArray = columnClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnClasses, ','));
        int columnClassesCount = columnClassesArray.length;
        String[] rowClassesArray = rowClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowClasses, ','));
        int rowClassesCount = rowClassesArray.length;
        int childCount = this.getChildCount(component);
        if (childCount > 0) {
            Object[] bodyrows = null;
            String bodyrowsAttr = (String)component.getAttributes().get("bodyrows");
            if (bodyrowsAttr != null && !"".equals(bodyrowsAttr)) {
                String[] bodyrowsString = StringUtils.trim(StringUtils.splitShortString(bodyrowsAttr, ','));
                bodyrows = new Integer[bodyrowsString.length];
                for (int i = 0; i < bodyrowsString.length; ++i) {
                    bodyrows[i] = new Integer(bodyrowsString[i]);
                }
            } else {
                bodyrows = ZERO_INT_ARRAY;
            }
            int bodyrowsCount = 0;
            int rowIndex = -1;
            int columnIndex = 0;
            int rowClassIndex = 0;
            boolean rowStarted = false;
            int size = component.getChildCount();
            for (int i = 0; i < size; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                if (!child.isRendered()) continue;
                if (columnIndex == 0) {
                    ++rowIndex;
                    if (rowStarted) {
                        writer.endElement("tr");
                        HtmlRendererUtils.writePrettyLineSeparator(context);
                    }
                    if (ArrayUtils.contains(bodyrows, rowIndex)) {
                        if (bodyrowsCount != 0) {
                            writer.endElement("tbody");
                            HtmlRendererUtils.writePrettyLineSeparator(context);
                        }
                        writer.startElement("tbody", component);
                        HtmlRendererUtils.writePrettyLineSeparator(context);
                        ++bodyrowsCount;
                    }
                    writer.startElement("tr", component);
                    if (rowClassIndex < rowClassesCount) {
                        writer.writeAttribute("class", (Object)rowClassesArray[rowClassIndex], null);
                    }
                    rowStarted = true;
                    if (++rowClassIndex == rowClassesCount) {
                        rowClassIndex = 0;
                    }
                }
                writer.startElement("td", component);
                if (columnIndex < columnClassesCount) {
                    writer.writeAttribute("class", (Object)columnClassesArray[columnIndex], null);
                }
                columnIndex = this.childAttributes(context, writer, child, columnIndex);
                child.encodeAll(context);
                writer.endElement("td");
                if (++columnIndex < columns) continue;
                columnIndex = 0;
            }
            if (rowStarted) {
                if (columnIndex > 0) {
                    Level level;
                    Level level2 = level = context.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
                    if (log.isLoggable(level)) {
                        log.log(level, "PanelGrid " + RendererUtils.getPathToComponent(component) + " has not enough children. Child count should be a " + "multiple of the columns attribute.");
                    }
                    while (columnIndex < columns) {
                        writer.startElement("td", component);
                        if (columnIndex < columnClassesCount) {
                            writer.writeAttribute("class", (Object)columnClassesArray[columnIndex], null);
                        }
                        writer.endElement("td");
                        ++columnIndex;
                    }
                }
                writer.endElement("tr");
                HtmlRendererUtils.writePrettyLineSeparator(context);
                if (bodyrowsCount != 0) {
                    writer.endElement("tbody");
                    HtmlRendererUtils.writePrettyLineSeparator(context);
                }
            }
        }
    }
}

