/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.ServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.myfaces.view.ResponseSwitch;
import org.apache.myfaces.view.SwitchableOutputStream;
import org.apache.myfaces.view.SwitchableWriter;

public class ServletResponseSwitch
extends ServletResponseWrapper
implements ResponseSwitch {
    private PrintWriter _switchableWriter;
    private SwitchableOutputStream _switchableOutputStream;
    private boolean _enabled = true;

    public ServletResponseSwitch(ServletResponse response) {
        super(response);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public int getBufferSize() {
        if (this.isEnabled()) {
            return super.getBufferSize();
        }
        return 0;
    }

    @Override
    public boolean isCommitted() {
        if (this.isEnabled()) {
            return super.isCommitted();
        }
        return false;
    }

    @Override
    public void reset() {
        if (this.isEnabled()) {
            super.reset();
        }
    }

    @Override
    public void resetBuffer() {
        if (this.isEnabled()) {
            super.resetBuffer();
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.isEnabled()) {
            super.flushBuffer();
        }
    }

    @Override
    public void setResponse(ServletResponse response) {
        if (response != this.getResponse()) {
            this._switchableOutputStream = null;
            this._switchableWriter = null;
            super.setResponse(response);
        }
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this._switchableOutputStream == null) {
            this._switchableOutputStream = new SwitchableOutputStream(super.getOutputStream(), this);
        }
        return this._switchableOutputStream;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this._switchableWriter == null) {
            this._switchableWriter = new PrintWriter(new SwitchableWriter(super.getWriter(), this));
        }
        return this._switchableWriter;
    }
}

