/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.validate;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.validator.BeanValidator;
import jakarta.faces.validator.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.myfaces.component.validate.WholeBeanValidator;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.util.WebConfigParamUtils;

public class ValidateWholeBeanComponent
extends UIInput {
    public static final String COMPONENT_FAMILY = "jakarta.faces.Input";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.component.validate.ValidateWholeBean";

    public ValidateWholeBeanComponent() {
        this.setRendererType(null);
    }

    @Override
    public Object getSubmittedValue() {
        return "WholeBeanValidator";
    }

    @Override
    public void addValidator(Validator validator) {
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        if (context.isProjectStage(ProjectStage.Development)) {
            UIForm closestForm = ComponentUtils.findClosest(UIForm.class, this);
            if (closestForm == null) {
                throw new IllegalStateException("f:validateWholeBean must be placed within a form");
            }
            this.validateTagPlacement(closestForm, this.getClientId(context));
        }
    }

    private void validateTagPlacement(UIComponent component, String clientId) throws IllegalStateException {
        List<UIComponent> children = component.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            UIComponent c = children.get(i);
            if (c instanceof EditableValueHolder && !(c instanceof ValidateWholeBeanComponent)) {
                Validator[] validators;
                for (Validator v : validators = ((EditableValueHolder)((Object)c)).getValidators()) {
                    if (!(v instanceof BeanValidator) || !((BeanValidator)v).getValidationGroups().equals(this.getValidationGroups())) continue;
                    throw new IllegalStateException("f:validateWholeBean must be placed after all validated inputs");
                }
                continue;
            }
            if (c.getClientId().equals(clientId)) {
                return;
            }
            this.validateTagPlacement(c, clientId);
        }
    }

    @Override
    public void validate(FacesContext context) {
        Boolean enabled = WebConfigParamUtils.getBooleanInitParameter(context.getExternalContext(), "jakarta.faces.validator.ENABLE_VALIDATE_WHOLE_BEAN", (boolean)Boolean.FALSE);
        if (Boolean.TRUE.equals(enabled) && !this.isDisabled()) {
            Validator[] validators = this.getValidators();
            if (validators == null || validators.length <= 0) {
                super.addValidator(new WholeBeanValidator());
            }
            super.validate(context);
        }
    }

    @Override
    public void setConverter(Converter converter) {
    }

    @Override
    public void updateModel(FacesContext context) {
    }

    public String getValidationGroups() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.validationGroups));
    }

    public void setValidationGroups(String validationGroups) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.validationGroups), validationGroups);
    }

    public boolean isDisabled() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabled), false);
    }

    public void setDisabled(boolean disabled) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabled), disabled);
    }

    static enum PropertyKeys {
        validationGroups,
        disabled;

    }
}

