/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesWrapper;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.EditableValueHolderAttachedObjectHandler;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandlerDelegate;
import jakarta.faces.view.facelets.ValidatorHandler;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.compiler.FaceletsCompilerUtils;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;

public class ValidatorTagHandlerDelegate
extends TagHandlerDelegate
implements EditableValueHolderAttachedObjectHandler,
FacesWrapper<ValidatorHandler> {
    public static final String VALIDATOR_ID_EXCLUSION_LIST_KEY = "org.apache.myfaces.validator.VALIDATOR_ID_EXCLUSION_LIST";
    private static final String BEAN_BEFORE_JSF_PROPERTY = "oam.beanBeforeJsf";
    private ValidatorHandler _delegate;
    private final boolean _wrapMode;
    private Boolean _beanBeforeJsfValidation;

    public ValidatorTagHandlerDelegate(ValidatorHandler delegate) {
        this._delegate = delegate;
        this._wrapMode = FaceletsCompilerUtils.hasChildren((TagConfig)this._delegate.getValidatorConfig());
        this._beanBeforeJsfValidation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
        if (this._wrapMode) {
            String validatorId = this._delegate.getValidatorConfig().getValidatorId();
            try {
                mctx.pushEnclosingValidatorIdToStack(validatorId, this);
                this._delegate.applyNextHandler(ctx, parent);
            }
            finally {
                mctx.popEnclosingValidatorIdToStack();
            }
        } else {
            if (!ComponentHandler.isNew((UIComponent)parent)) {
                return;
            }
            if (parent instanceof EditableValueHolder) {
                this.applyAttachedObject(ctx.getFacesContext(), parent);
            } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
                if (this.getFor() == null) {
                    throw new TagException(this._delegate.getTag(), "is nested inside a composite component but does not have a for attribute.");
                }
                mctx.addAttachedObjectHandler(parent, (AttachedObjectHandler)this._delegate);
            } else {
                throw new TagException(this._delegate.getTag(), "Parent not composite component or an instance of EditableValueHolder: " + String.valueOf(parent));
            }
        }
    }

    protected Validator createValidator(FaceletContext ctx) {
        if (this._delegate.getValidatorId(ctx) == null) {
            throw new TagException(this._delegate.getTag(), "Default behavior invoked of requiring a validator-id passed in the constructor, must override ValidateHandler(ValidatorConfig)");
        }
        return ctx.getFacesContext().getApplication().createValidator(this._delegate.getValidatorId(ctx));
    }

    public MetaRuleset createMetaRuleset(Class type) {
        MetaRulesetImpl metaRuleset = new MetaRulesetImpl(this._delegate.getTag(), type);
        metaRuleset.ignore("binding").ignore("disabled");
        metaRuleset.ignore("for");
        return metaRuleset;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        if (this._delegate.isDisabled(faceletContext)) {
            String validatorId = this._delegate.getValidatorConfig().getValidatorId();
            if (validatorId != null && !validatorId.isEmpty()) {
                ArrayList<String> exclusionList = (ArrayList<String>)parent.getAttributes().get(VALIDATOR_ID_EXCLUSION_LIST_KEY);
                if (exclusionList == null) {
                    exclusionList = new ArrayList<String>();
                    parent.getAttributes().put(VALIDATOR_ID_EXCLUSION_LIST_KEY, exclusionList);
                }
                exclusionList.add(validatorId);
            }
        } else {
            EditableValueHolder evh = (EditableValueHolder)parent;
            ValueExpression ve = null;
            Validator v = null;
            if (this._delegate.getBinding() != null) {
                ve = this._delegate.getBinding().getValueExpression(faceletContext, Validator.class);
                v = (Validator)ve.getValue((ELContext)faceletContext);
            }
            if (v == null) {
                v = this.createValidator(faceletContext);
                if (ve != null) {
                    ve.setValue((ELContext)faceletContext, (Object)v);
                }
            }
            if (v == null) {
                throw new TagException(this._delegate.getTag(), "No Validator was created");
            }
            this._delegate.setAttributes(faceletContext, (Object)v);
            if (this.shouldBeanBeforeJsfValidationEnabled(context)) {
                parent.getAttributes().put(BEAN_BEFORE_JSF_PROPERTY, Boolean.TRUE);
            }
            evh.addValidator(v);
        }
    }

    private boolean shouldBeanBeforeJsfValidationEnabled(FacesContext context) {
        if (this._beanBeforeJsfValidation == null) {
            this._beanBeforeJsfValidation = MyfacesConfig.getCurrentInstance(context).isBeanBeforeJsfValidation();
        }
        return this._beanBeforeJsfValidation;
    }

    public String getFor() {
        TagAttribute forAttribute = this._delegate.getTagAttribute("for");
        if (forAttribute == null) {
            return null;
        }
        return forAttribute.getValue();
    }

    public String getValidationGroups(FaceletContext ctx) {
        TagAttribute attribute = this._delegate.getTagAttribute("validationGroups");
        if (attribute == null) {
            return null;
        }
        return attribute.getValue(ctx);
    }

    public ValidatorHandler getWrapped() {
        return this._delegate;
    }
}

