/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.apache.myfaces.extensions.validator.beanval.ExtValBeanValidationContext;
import org.apache.myfaces.extensions.validator.beanval.storage.ModelValidationEntry;
import org.apache.myfaces.extensions.validator.beanval.util.ExtValBeanValidationMetaDataInternals;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.validation.message.FacesMessageHolder;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class BeanValidationUtils {
    private static final Logger LOGGER = Logger.getLogger(BeanValidationUtils.class.getName());
    private static ELHelper elHelper = ExtValUtils.getELHelper();
    private static ExtValBeanValidationMetaDataInternals bvmi = new ExtValBeanValidationMetaDataInternals(LOGGER, elHelper);
    private static final String VALIDATOR_FACTORY_KEY = "javax.faces.validator.beanValidator.ValidatorFactory";

    public static Set<ConstraintViolation<Object>> validate(Class baseClass, String propertyName, Object objectToValidate, Class[] groups, boolean cascadedValidation) {
        ValidatorFactory validatorFactory = ExtValBeanValidationContext.getCurrentInstance().getValidatorFactory();
        Set<ConstraintViolation<Object>> result = validatorFactory.usingContext().messageInterpolator(ExtValBeanValidationContext.getCurrentInstance().getMessageInterpolator()).constraintValidatorFactory(validatorFactory.getConstraintValidatorFactory()).traversableResolver(validatorFactory.getTraversableResolver()).getValidator().validateValue(baseClass, propertyName, objectToValidate, groups);
        if (result.isEmpty() && cascadedValidation && objectToValidate != null) {
            result = BeanValidationUtils.processCascadedValidation(validatorFactory, baseClass, propertyName, objectToValidate, groups);
        }
        return result;
    }

    private static Set<ConstraintViolation<Object>> processCascadedValidation(ValidatorFactory validatorFactory, Class baseBeanClass, String propertyName, Object objectToValidate, Class[] groups) {
        ElementDescriptor elementDescriptor = BeanValidationUtils.getElementDescriptor(baseBeanClass, propertyName);
        if (elementDescriptor instanceof PropertyDescriptor && ((PropertyDescriptor)elementDescriptor).isCascaded()) {
            return validatorFactory.usingContext().messageInterpolator(ExtValBeanValidationContext.getCurrentInstance().getMessageInterpolator()).constraintValidatorFactory(validatorFactory.getConstraintValidatorFactory()).traversableResolver(validatorFactory.getTraversableResolver()).getValidator().validate(objectToValidate, groups);
        }
        return Collections.emptySet();
    }

    public static ElementDescriptor getElementDescriptor(Class targetClass, String property) {
        BeanDescriptor beanDescriptor = ExtValBeanValidationContext.getCurrentInstance().getValidatorFactory().getValidator().getConstraintsForClass(targetClass);
        return beanDescriptor.getConstraintsForProperty(property);
    }

    public static void addMetaDataToContext(UIComponent component, PropertyDetails propertyDetails, boolean processModelValidation) {
        String[] key = propertyDetails.getKey().split("\\.");
        Object firstBean = elHelper.getBean(key[0]);
        ArrayList<Class> foundGroupsForPropertyValidation = new ArrayList<Class>();
        ArrayList<Class> restrictedGroupsForPropertyValidation = new ArrayList<Class>();
        ArrayList<ModelValidationEntry> modelValidationEntryList = new ArrayList<ModelValidationEntry>();
        ArrayList<Class> restrictedGroupsForModelValidation = new ArrayList<Class>();
        String activeViewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        bvmi.extractExtValBeanValidationMetaData(propertyDetails, processModelValidation, key, firstBean, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId);
        bvmi.processExtValBeanValidationMetaData(component, propertyDetails, foundGroupsForPropertyValidation, restrictedGroupsForPropertyValidation, modelValidationEntryList, restrictedGroupsForModelValidation, activeViewId);
    }

    public static void processConstraintViolations(FacesContext facesContext, UIComponent uiComponent, Object convertedObject, Set<ConstraintViolation<Object>> violations) {
        ArrayList<FacesMessageHolder> facesMessageHolderList = new ArrayList<FacesMessageHolder>();
        for (ConstraintViolation<Object> violation : violations) {
            FacesMessage facesMessage = BeanValidationUtils.createFacesMessageForConstraintViolation(uiComponent, convertedObject, violation);
            if (facesMessage == null) continue;
            bvmi.processFacesMessage(facesContext, uiComponent, facesMessageHolderList, facesMessage);
        }
        BeanValidationUtils.processViolationMessages(facesMessageHolderList);
    }

    public static FacesMessage createFacesMessageForConstraintViolation(UIComponent uiComponent, Object convertedObject, ConstraintViolation<Object> violation) {
        FacesMessage.Severity severity;
        String labeledMessageDetail;
        String violationMessage = violation.getMessage();
        String labeledMessageSummary = bvmi.createLabeledMessage(violationMessage, false);
        ValidatorException validatorException = bvmi.createValidatorException(labeledMessageSummary, labeledMessageDetail = bvmi.createLabeledMessage(violationMessage, true), severity = bvmi.calcSeverity(violation));
        if (!bvmi.executeAfterThrowingInterceptors(uiComponent, convertedObject, validatorException)) {
            return null;
        }
        if (bvmi.isMessageTextUnchanged(validatorException, labeledMessageSummary, labeledMessageDetail)) {
            return ExtValUtils.createFacesMessage((FacesMessage.Severity)severity, (String)violationMessage, (String)violationMessage);
        }
        return ExtValUtils.createFacesMessage((FacesMessage.Severity)severity, (String)validatorException.getFacesMessage().getSummary(), (String)validatorException.getFacesMessage().getDetail());
    }

    public static void processViolationMessages(List<FacesMessageHolder> violationMessageHolderList) {
        if (violationMessageHolderList == null || violationMessageHolderList.isEmpty()) {
            return;
        }
        List<FacesMessageHolder> facesMessageListWithLowSeverity = bvmi.getFacesMessageListWithLowSeverity(violationMessageHolderList);
        List<FacesMessageHolder> facesMessageListWithHighSeverity = bvmi.getFacesMessageListWithHighSeverity(violationMessageHolderList);
        bvmi.addMessages(facesMessageListWithHighSeverity);
        bvmi.addMessages(facesMessageListWithLowSeverity);
    }

    public static ValidatorFactory getDefaultValidatorFactory() {
        Map applicationMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        ValidatorFactory validatorFactory = null;
        if (applicationMap.containsKey(VALIDATOR_FACTORY_KEY) && applicationMap.get(VALIDATOR_FACTORY_KEY) instanceof ValidatorFactory) {
            validatorFactory = (ValidatorFactory)applicationMap.get(VALIDATOR_FACTORY_KEY);
        }
        if (validatorFactory == null) {
            validatorFactory = Validation.buildDefaultValidatorFactory();
            applicationMap.put(VALIDATOR_FACTORY_KEY, validatorFactory);
        }
        return validatorFactory;
    }
}

