/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.util;

import java.util.MissingResourceException;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.JsfUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
class LabeledMessageInternals {
    private final String defaultSummaryMessageTemplate = "{1}: {0}";
    private final String defaultDetailMessageTemplate = "{1}: {0}";
    private String summaryMessageTemplate = "{1}: {0}";
    private String detailMessageTemplate = "{1}: {0}";
    private static final String JAVAX_FACES_VALIDATOR_BEANVALIDATOR_MESSAGE = "javax.faces.validator.BeanValidator.MESSAGE";
    private static final String JAVAX_FACES_VALIDATOR_BEANVALIDATOR_MESSAGE_DETAIL = "javax.faces.validator.BeanValidator.MESSAGE_detail";

    LabeledMessageInternals() {
    }

    String createLabeledMessage(String violationMessage, boolean isDetailMessage) {
        if (isDetailMessage) {
            return this.tryToResolveDetailMessage(violationMessage);
        }
        return this.tryToResolveSummaryMessage(violationMessage);
    }

    private String tryToResolveSummaryMessage(String violationMessage) {
        if (this.summaryMessageTemplate == null) {
            this.getClass();
            return "{1}: {0}".replace("{0}", violationMessage);
        }
        this.summaryMessageTemplate = this.loadStandardMessageTemplate(false);
        if (this.summaryMessageTemplate == null) {
            return this.createLabeledMessage(violationMessage, false);
        }
        return this.summaryMessageTemplate.replace("{0}", violationMessage);
    }

    private String tryToResolveDetailMessage(String violationMessage) {
        if (this.detailMessageTemplate == null) {
            this.getClass();
            return "{1}: {0}".replace("{0}", violationMessage);
        }
        this.detailMessageTemplate = this.loadStandardMessageTemplate(true);
        if (this.detailMessageTemplate == null) {
            return this.createLabeledMessage(violationMessage, true);
        }
        return this.detailMessageTemplate.replace("{0}", violationMessage);
    }

    private String loadStandardMessageTemplate(boolean isDetailMessage) {
        try {
            if (isDetailMessage) {
                return JsfUtils.getMessageFromApplicationMessageBundle((String)JAVAX_FACES_VALIDATOR_BEANVALIDATOR_MESSAGE_DETAIL);
            }
            return JsfUtils.getMessageFromApplicationMessageBundle((String)JAVAX_FACES_VALIDATOR_BEANVALIDATOR_MESSAGE);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

