/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.strategy;

import javax.faces.application.FacesMessage;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.baseval.annotation.SkipValidationSupport;
import org.apache.myfaces.extensions.validator.core.validation.EmptyValueAwareValidationStrategy;
import org.apache.myfaces.extensions.validator.core.validation.NullValueAwareValidationStrategy;
import org.apache.myfaces.extensions.validator.crossval.annotation.MessageTarget;
import org.apache.myfaces.extensions.validator.crossval.annotation.RequiredIf;
import org.apache.myfaces.extensions.validator.crossval.annotation.RequiredIfType;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.strategy.AbstractCompareStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SkipValidationSupport
@NullValueAwareValidationStrategy
@EmptyValueAwareValidationStrategy
@UsageInformation(value={UsageCategory.INTERNAL})
public class RequiredIfStrategy
extends AbstractCompareStrategy<RequiredIf> {
    private boolean useFacesBundle = false;

    @Override
    protected MessageTarget getMessageTarget(RequiredIf annotation) {
        return annotation.validationErrorMsgTarget();
    }

    protected String resolveMessage(String key) {
        String result = super.resolveMessage(key);
        String marker = "???";
        if ((marker + key + marker).equals(result)) {
            this.useFacesBundle = true;
        }
        return result;
    }

    @Override
    protected String getValidationErrorMsgKey(RequiredIf annotation, boolean isTargetComponent) {
        return annotation.validationErrorMsgKey();
    }

    @Override
    public boolean isViolation(Object source, Object target, RequiredIf annotation) {
        boolean violationFound = false;
        if (annotation.is().equals((Object)RequiredIfType.empty)) {
            violationFound = (this.isTargetEmpty(target) || Boolean.FALSE.equals(target)) && this.isSourceEmpty(source);
        } else if (annotation.is().equals((Object)RequiredIfType.not_empty)) {
            violationFound = this.isTargetNotEmpty(target) && this.isSourceEmpty(source) && !(target instanceof Boolean) || Boolean.TRUE.equals(target) && this.isSourceEmpty(source);
        }
        return violationFound;
    }

    private boolean isTargetEmpty(Object target) {
        return target == null || target.equals("");
    }

    private boolean isSourceEmpty(Object source) {
        return source == null || source.equals("");
    }

    private boolean isTargetNotEmpty(Object target) {
        return target != null && !target.equals("");
    }

    @Override
    public String[] getValidationTargets(RequiredIf annotation) {
        return annotation.valueOf();
    }

    @Override
    protected boolean processAfterCrossValidatorException(CrossValidationStorageEntry crossValidationStorageEntry, ValidatorException validatorException) {
        if (this.useFacesBundle) {
            ExtValUtils.replaceWithDefaultRequiredMessage((FacesMessage)validatorException.getFacesMessage());
        }
        return super.processAfterCrossValidatorException(crossValidationStorageEntry, validatorException);
    }
}

