/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad.util;

import java.util.logging.Logger;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputLabel;

@UsageInformation(value={UsageCategory.INTERNAL})
@ToDo(value=Priority.MEDIUM, description="check subform")
public class TrinidadUtils {
    protected static final Logger LOG = Logger.getLogger(TrinidadUtils.class.getName());

    public static UIComponent findLabeledEditableComponent(CoreOutputLabel coreOutputLabel) {
        if (TrinidadUtils.isLabelTargetAvailable(coreOutputLabel)) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIComponent result = TrinidadUtils.resolveLabelTarget(facesContext, coreOutputLabel);
        if (result instanceof EditableValueHolder) {
            return result;
        }
        LOG.finest(coreOutputLabel.getClientId(facesContext) + " doesn't reference an editable component");
        return null;
    }

    private static UIComponent resolveLabelTarget(FacesContext facesContext, CoreOutputLabel coreOutputLabel) {
        return facesContext.getViewRoot().findComponent(coreOutputLabel.getFor());
    }

    private static boolean isLabelTargetAvailable(CoreOutputLabel coreOutputLabel) {
        return coreOutputLabel.getFor() == null;
    }
}

