/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tomahawk.application;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.apache.myfaces.custom.autoscroll.AutoscrollBodyScript;
import org.apache.myfaces.custom.autoscroll.AutoscrollHiddenField;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.tomahawk.application.PreRenderViewAddResourceEvent;
import org.apache.myfaces.tomahawk.util.TomahawkResourceUtils;

public class ResourceViewHandlerWrapper
extends ViewHandlerWrapper {
    private static final String SET_RESOURCE_CONTAINER_DUMMY_COMPONENT_ID = "oam_autoscroll_setResourceContainer";
    private static final String BODY_SCRIPT_COMPONENT_ID = "oam_autoscroll_body_script";
    private static final String HIDDEN_FIELD_COMPONENT_ID = "oam_autoscroll_hidden_field";
    private ViewHandler _delegate;

    public ResourceViewHandlerWrapper(ViewHandler delegate) {
        this._delegate = delegate;
    }

    public ViewHandler getWrapped() {
        return this._delegate;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot root = super.createView(context, viewId);
        root.subscribeToViewEvent(PostAddToViewEvent.class, new SystemEventListener(){

            public boolean isListenerForSource(Object o) {
                return o instanceof UIViewRoot;
            }

            public void processEvent(SystemEvent se) {
                FacesContext context = FacesContext.getCurrentInstance();
                UIViewRoot viewToRender = (UIViewRoot)se.getSource();
                if (MyfacesConfig.getCurrentInstance(context.getExternalContext()).isAutoScroll() || viewToRender.getAttributes().containsKey("oam.autoscroll.AUTOSCROLL_TAG_ON_PAGE")) {
                    UIOutput test = new UIOutput();
                    test.setId(ResourceViewHandlerWrapper.SET_RESOURCE_CONTAINER_DUMMY_COMPONENT_ID);
                    test.setTransient(true);
                    UIComponent facet = null;
                    facet = viewToRender.getFacet("form");
                    if (facet == null) {
                        viewToRender.addComponentResource(context, (UIComponent)test, "form");
                        facet = viewToRender.getFacet("form");
                        if (facet != null) {
                            facet.getChildren().remove(test);
                        }
                    }
                    if ((facet = viewToRender.getFacet("body")) == null) {
                        viewToRender.addComponentResource(context, (UIComponent)test, "body");
                        facet = viewToRender.getFacet("body");
                        if (facet != null) {
                            facet.getChildren().remove(test);
                        }
                    }
                    if ((facet = viewToRender.getFacet("head")) == null) {
                        viewToRender.addComponentResource(context, (UIComponent)test, "head");
                        facet = viewToRender.getFacet("head");
                        if (facet != null) {
                            facet.getChildren().remove(test);
                        }
                    }
                }
            }
        });
        return root;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (MyfacesConfig.getCurrentInstance(context.getExternalContext()).isAutoScroll() || viewToRender.getAttributes().containsKey("oam.autoscroll.AUTOSCROLL_TAG_ON_PAGE")) {
            AddResource addResource = AddResourceFactory.getInstance(context);
            if (!addResource.requiresBuffer()) {
                AutoscrollBodyScript autoscrollBodyScript = (AutoscrollBodyScript)context.getApplication().createComponent(context, "org.apache.myfaces.custom.autoscroll.AutoscrollBodyScript", "org.apache.myfaces.custom.autoscroll.AutoscrollBodyScript");
                autoscrollBodyScript.setId(BODY_SCRIPT_COMPONENT_ID);
                autoscrollBodyScript.setTransient(true);
                autoscrollBodyScript.getAttributes().put("target", "body");
                viewToRender.addComponentResource(context, (UIComponent)autoscrollBodyScript);
            }
            AutoscrollHiddenField autoscrollHiddenField = (AutoscrollHiddenField)context.getApplication().createComponent(context, "org.apache.myfaces.custom.autoscroll.AutoscrollHiddenField", "org.apache.myfaces.custom.autoscroll.AutoscrollHiddenField");
            autoscrollHiddenField.setId(HIDDEN_FIELD_COMPONENT_ID);
            autoscrollHiddenField.setTransient(true);
            autoscrollHiddenField.getAttributes().put("target", "form");
            viewToRender.addComponentResource(context, (UIComponent)autoscrollHiddenField);
        }
        TomahawkResourceUtils.resetAddedResources(context);
        this._publishPreRenderViewAddResourceEvent(context, (UIComponent)viewToRender);
        super.renderView(context, viewToRender);
    }

    private void _publishPreRenderViewAddResourceEvent(FacesContext context, UIComponent component) {
        context.getApplication().publishEvent(context, PreRenderViewAddResourceEvent.class, UIComponent.class, (Object)component);
        if (component.getChildCount() > 0) {
            for (UIComponent uIComponent : component.getChildren()) {
                this._publishPreRenderViewAddResourceEvent(context, uIComponent);
            }
        }
        if (component.getFacetCount() > 0) {
            for (Map.Entry entry : component.getFacets().entrySet()) {
                this._publishPreRenderViewAddResourceEvent(context, (UIComponent)entry.getValue());
            }
        }
    }
}

