/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import java.util.Collections;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class StringBufferCharConstructor {
    public static ErrorDescription run(HintContext ctx) {
        TreePath p = ctx.getPath();
        TypeMirror paramType = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$x"));
        if (paramType.getKind() != TypeKind.CHAR) {
            if (paramType.getKind() != TypeKind.DECLARED) {
                return null;
            }
            Element el = ((DeclaredType)paramType).asElement();
            if (el == null || el.getKind() != ElementKind.CLASS) {
                return null;
            }
            if (!((TypeElement)el).getQualifiedName().contentEquals("java.lang.Character")) {
                return null;
            }
        }
        TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(p);
        CharSequence tname = ctx.getInfo().getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0]);
        return ErrorDescriptionFactory.forTree(ctx, p, Bundle.TEXT_StringBufferCharConstructor(tname), new NewAndAppendFix(TreePathHandle.create(p, ctx.getInfo()), tname.toString()).toEditorFix());
    }

    private static class NewAndAppendFix
    extends JavaFix {
        final String builder;

        public NewAndAppendFix(TreePathHandle handle, String builder) {
            super(handle);
            this.builder = builder;
        }

        @Override
        protected String getText() {
            return Bundle.FIX_StringBufferCharConstructor(this.builder);
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath p = ctx.getPath();
            if (p.getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                return;
            }
            NewClassTree origNct = (NewClassTree)p.getLeaf();
            if (origNct.getArguments().size() != 1) {
                return;
            }
            NewClassTree nct = GeneratorUtilities.get(ctx.getWorkingCopy()).importComments(origNct, ctx.getWorkingCopy().getCompilationUnit());
            ExpressionTree charArg = nct.getArguments().get(0);
            TreeMaker mk = ctx.getWorkingCopy().getTreeMaker();
            NewClassTree newExpr = mk.NewClass(nct.getEnclosingExpression(), nct.getTypeArguments(), nct.getIdentifier(), Collections.emptyList(), nct.getClassBody());
            MethodInvocationTree replace = mk.MethodInvocation(Collections.emptyList(), mk.MemberSelect((ExpressionTree)newExpr, "append"), Collections.singletonList(charArg));
            ctx.getWorkingCopy().rewrite(nct, replace);
        }
    }
}

