/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NLMUpdateKeyUpdate is the corresponding interface of NLMUpdateKeyUpdate
type NLMUpdateKeyUpdate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	NLM
	// GetControlFlags returns ControlFlags (property field)
	GetControlFlags() NLMUpdateKeyUpdateControlFlags
	// GetSet1KeyRevision returns Set1KeyRevision (property field)
	GetSet1KeyRevision() *byte
	// GetSet1ActivationTime returns Set1ActivationTime (property field)
	GetSet1ActivationTime() *uint32
	// GetSet1ExpirationTime returns Set1ExpirationTime (property field)
	GetSet1ExpirationTime() *uint32
	// GetSet1KeyCount returns Set1KeyCount (property field)
	GetSet1KeyCount() *uint8
	// GetSet1Keys returns Set1Keys (property field)
	GetSet1Keys() []NLMUpdateKeyUpdateKeyEntry
	// GetSet2KeyRevision returns Set2KeyRevision (property field)
	GetSet2KeyRevision() *byte
	// GetSet2ActivationTime returns Set2ActivationTime (property field)
	GetSet2ActivationTime() *uint32
	// GetSet2ExpirationTime returns Set2ExpirationTime (property field)
	GetSet2ExpirationTime() *uint32
	// GetSet2KeyCount returns Set2KeyCount (property field)
	GetSet2KeyCount() *uint8
	// GetSet2Keys returns Set2Keys (property field)
	GetSet2Keys() []NLMUpdateKeyUpdateKeyEntry
	// IsNLMUpdateKeyUpdate is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNLMUpdateKeyUpdate()
	// CreateBuilder creates a NLMUpdateKeyUpdateBuilder
	CreateNLMUpdateKeyUpdateBuilder() NLMUpdateKeyUpdateBuilder
}

// _NLMUpdateKeyUpdate is the data-structure of this message
type _NLMUpdateKeyUpdate struct {
	NLMContract
	ControlFlags       NLMUpdateKeyUpdateControlFlags
	Set1KeyRevision    *byte
	Set1ActivationTime *uint32
	Set1ExpirationTime *uint32
	Set1KeyCount       *uint8
	Set1Keys           []NLMUpdateKeyUpdateKeyEntry
	Set2KeyRevision    *byte
	Set2ActivationTime *uint32
	Set2ExpirationTime *uint32
	Set2KeyCount       *uint8
	Set2Keys           []NLMUpdateKeyUpdateKeyEntry
}

var _ NLMUpdateKeyUpdate = (*_NLMUpdateKeyUpdate)(nil)
var _ NLMRequirements = (*_NLMUpdateKeyUpdate)(nil)

// NewNLMUpdateKeyUpdate factory function for _NLMUpdateKeyUpdate
func NewNLMUpdateKeyUpdate(controlFlags NLMUpdateKeyUpdateControlFlags, set1KeyRevision *byte, set1ActivationTime *uint32, set1ExpirationTime *uint32, set1KeyCount *uint8, set1Keys []NLMUpdateKeyUpdateKeyEntry, set2KeyRevision *byte, set2ActivationTime *uint32, set2ExpirationTime *uint32, set2KeyCount *uint8, set2Keys []NLMUpdateKeyUpdateKeyEntry, apduLength uint16) *_NLMUpdateKeyUpdate {
	if controlFlags == nil {
		panic("controlFlags of type NLMUpdateKeyUpdateControlFlags for NLMUpdateKeyUpdate must not be nil")
	}
	_result := &_NLMUpdateKeyUpdate{
		NLMContract:        NewNLM(apduLength),
		ControlFlags:       controlFlags,
		Set1KeyRevision:    set1KeyRevision,
		Set1ActivationTime: set1ActivationTime,
		Set1ExpirationTime: set1ExpirationTime,
		Set1KeyCount:       set1KeyCount,
		Set1Keys:           set1Keys,
		Set2KeyRevision:    set2KeyRevision,
		Set2ActivationTime: set2ActivationTime,
		Set2ExpirationTime: set2ExpirationTime,
		Set2KeyCount:       set2KeyCount,
		Set2Keys:           set2Keys,
	}
	_result.NLMContract.(*_NLM)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NLMUpdateKeyUpdateBuilder is a builder for NLMUpdateKeyUpdate
type NLMUpdateKeyUpdateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(controlFlags NLMUpdateKeyUpdateControlFlags, set1Keys []NLMUpdateKeyUpdateKeyEntry, set2Keys []NLMUpdateKeyUpdateKeyEntry) NLMUpdateKeyUpdateBuilder
	// WithControlFlags adds ControlFlags (property field)
	WithControlFlags(NLMUpdateKeyUpdateControlFlags) NLMUpdateKeyUpdateBuilder
	// WithControlFlagsBuilder adds ControlFlags (property field) which is build by the builder
	WithControlFlagsBuilder(func(NLMUpdateKeyUpdateControlFlagsBuilder) NLMUpdateKeyUpdateControlFlagsBuilder) NLMUpdateKeyUpdateBuilder
	// WithSet1KeyRevision adds Set1KeyRevision (property field)
	WithOptionalSet1KeyRevision(byte) NLMUpdateKeyUpdateBuilder
	// WithSet1ActivationTime adds Set1ActivationTime (property field)
	WithOptionalSet1ActivationTime(uint32) NLMUpdateKeyUpdateBuilder
	// WithSet1ExpirationTime adds Set1ExpirationTime (property field)
	WithOptionalSet1ExpirationTime(uint32) NLMUpdateKeyUpdateBuilder
	// WithSet1KeyCount adds Set1KeyCount (property field)
	WithOptionalSet1KeyCount(uint8) NLMUpdateKeyUpdateBuilder
	// WithSet1Keys adds Set1Keys (property field)
	WithSet1Keys(...NLMUpdateKeyUpdateKeyEntry) NLMUpdateKeyUpdateBuilder
	// WithSet2KeyRevision adds Set2KeyRevision (property field)
	WithOptionalSet2KeyRevision(byte) NLMUpdateKeyUpdateBuilder
	// WithSet2ActivationTime adds Set2ActivationTime (property field)
	WithOptionalSet2ActivationTime(uint32) NLMUpdateKeyUpdateBuilder
	// WithSet2ExpirationTime adds Set2ExpirationTime (property field)
	WithOptionalSet2ExpirationTime(uint32) NLMUpdateKeyUpdateBuilder
	// WithSet2KeyCount adds Set2KeyCount (property field)
	WithOptionalSet2KeyCount(uint8) NLMUpdateKeyUpdateBuilder
	// WithSet2Keys adds Set2Keys (property field)
	WithSet2Keys(...NLMUpdateKeyUpdateKeyEntry) NLMUpdateKeyUpdateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() NLMBuilder
	// Build builds the NLMUpdateKeyUpdate or returns an error if something is wrong
	Build() (NLMUpdateKeyUpdate, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NLMUpdateKeyUpdate
}

// NewNLMUpdateKeyUpdateBuilder() creates a NLMUpdateKeyUpdateBuilder
func NewNLMUpdateKeyUpdateBuilder() NLMUpdateKeyUpdateBuilder {
	return &_NLMUpdateKeyUpdateBuilder{_NLMUpdateKeyUpdate: new(_NLMUpdateKeyUpdate)}
}

type _NLMUpdateKeyUpdateBuilder struct {
	*_NLMUpdateKeyUpdate

	parentBuilder *_NLMBuilder

	collectedErr []error
}

var _ (NLMUpdateKeyUpdateBuilder) = (*_NLMUpdateKeyUpdateBuilder)(nil)

func (b *_NLMUpdateKeyUpdateBuilder) setParent(contract NLMContract) {
	b.NLMContract = contract
	contract.(*_NLM)._SubType = b._NLMUpdateKeyUpdate
}

func (b *_NLMUpdateKeyUpdateBuilder) WithMandatoryFields(controlFlags NLMUpdateKeyUpdateControlFlags, set1Keys []NLMUpdateKeyUpdateKeyEntry, set2Keys []NLMUpdateKeyUpdateKeyEntry) NLMUpdateKeyUpdateBuilder {
	return b.WithControlFlags(controlFlags).WithSet1Keys(set1Keys...).WithSet2Keys(set2Keys...)
}

func (b *_NLMUpdateKeyUpdateBuilder) WithControlFlags(controlFlags NLMUpdateKeyUpdateControlFlags) NLMUpdateKeyUpdateBuilder {
	b.ControlFlags = controlFlags
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithControlFlagsBuilder(builderSupplier func(NLMUpdateKeyUpdateControlFlagsBuilder) NLMUpdateKeyUpdateControlFlagsBuilder) NLMUpdateKeyUpdateBuilder {
	builder := builderSupplier(b.ControlFlags.CreateNLMUpdateKeyUpdateControlFlagsBuilder())
	var err error
	b.ControlFlags, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NLMUpdateKeyUpdateControlFlagsBuilder failed"))
	}
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithOptionalSet1KeyRevision(set1KeyRevision byte) NLMUpdateKeyUpdateBuilder {
	b.Set1KeyRevision = &set1KeyRevision
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithOptionalSet1ActivationTime(set1ActivationTime uint32) NLMUpdateKeyUpdateBuilder {
	b.Set1ActivationTime = &set1ActivationTime
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithOptionalSet1ExpirationTime(set1ExpirationTime uint32) NLMUpdateKeyUpdateBuilder {
	b.Set1ExpirationTime = &set1ExpirationTime
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithOptionalSet1KeyCount(set1KeyCount uint8) NLMUpdateKeyUpdateBuilder {
	b.Set1KeyCount = &set1KeyCount
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithSet1Keys(set1Keys ...NLMUpdateKeyUpdateKeyEntry) NLMUpdateKeyUpdateBuilder {
	b.Set1Keys = set1Keys
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithOptionalSet2KeyRevision(set2KeyRevision byte) NLMUpdateKeyUpdateBuilder {
	b.Set2KeyRevision = &set2KeyRevision
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithOptionalSet2ActivationTime(set2ActivationTime uint32) NLMUpdateKeyUpdateBuilder {
	b.Set2ActivationTime = &set2ActivationTime
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithOptionalSet2ExpirationTime(set2ExpirationTime uint32) NLMUpdateKeyUpdateBuilder {
	b.Set2ExpirationTime = &set2ExpirationTime
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithOptionalSet2KeyCount(set2KeyCount uint8) NLMUpdateKeyUpdateBuilder {
	b.Set2KeyCount = &set2KeyCount
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) WithSet2Keys(set2Keys ...NLMUpdateKeyUpdateKeyEntry) NLMUpdateKeyUpdateBuilder {
	b.Set2Keys = set2Keys
	return b
}

func (b *_NLMUpdateKeyUpdateBuilder) Build() (NLMUpdateKeyUpdate, error) {
	if b.ControlFlags == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'controlFlags' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._NLMUpdateKeyUpdate.deepCopy(), nil
}

func (b *_NLMUpdateKeyUpdateBuilder) MustBuild() NLMUpdateKeyUpdate {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NLMUpdateKeyUpdateBuilder) Done() NLMBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewNLMBuilder().(*_NLMBuilder)
	}
	return b.parentBuilder
}

func (b *_NLMUpdateKeyUpdateBuilder) buildForNLM() (NLM, error) {
	return b.Build()
}

func (b *_NLMUpdateKeyUpdateBuilder) DeepCopy() any {
	_copy := b.CreateNLMUpdateKeyUpdateBuilder().(*_NLMUpdateKeyUpdateBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateNLMUpdateKeyUpdateBuilder creates a NLMUpdateKeyUpdateBuilder
func (b *_NLMUpdateKeyUpdate) CreateNLMUpdateKeyUpdateBuilder() NLMUpdateKeyUpdateBuilder {
	if b == nil {
		return NewNLMUpdateKeyUpdateBuilder()
	}
	return &_NLMUpdateKeyUpdateBuilder{_NLMUpdateKeyUpdate: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NLMUpdateKeyUpdate) GetMessageType() uint8 {
	return 0x0E
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NLMUpdateKeyUpdate) GetParent() NLMContract {
	return m.NLMContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NLMUpdateKeyUpdate) GetControlFlags() NLMUpdateKeyUpdateControlFlags {
	return m.ControlFlags
}

func (m *_NLMUpdateKeyUpdate) GetSet1KeyRevision() *byte {
	return m.Set1KeyRevision
}

func (m *_NLMUpdateKeyUpdate) GetSet1ActivationTime() *uint32 {
	return m.Set1ActivationTime
}

func (m *_NLMUpdateKeyUpdate) GetSet1ExpirationTime() *uint32 {
	return m.Set1ExpirationTime
}

func (m *_NLMUpdateKeyUpdate) GetSet1KeyCount() *uint8 {
	return m.Set1KeyCount
}

func (m *_NLMUpdateKeyUpdate) GetSet1Keys() []NLMUpdateKeyUpdateKeyEntry {
	return m.Set1Keys
}

func (m *_NLMUpdateKeyUpdate) GetSet2KeyRevision() *byte {
	return m.Set2KeyRevision
}

func (m *_NLMUpdateKeyUpdate) GetSet2ActivationTime() *uint32 {
	return m.Set2ActivationTime
}

func (m *_NLMUpdateKeyUpdate) GetSet2ExpirationTime() *uint32 {
	return m.Set2ExpirationTime
}

func (m *_NLMUpdateKeyUpdate) GetSet2KeyCount() *uint8 {
	return m.Set2KeyCount
}

func (m *_NLMUpdateKeyUpdate) GetSet2Keys() []NLMUpdateKeyUpdateKeyEntry {
	return m.Set2Keys
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNLMUpdateKeyUpdate(structType any) NLMUpdateKeyUpdate {
	if casted, ok := structType.(NLMUpdateKeyUpdate); ok {
		return casted
	}
	if casted, ok := structType.(*NLMUpdateKeyUpdate); ok {
		return *casted
	}
	return nil
}

func (m *_NLMUpdateKeyUpdate) GetTypeName() string {
	return "NLMUpdateKeyUpdate"
}

func (m *_NLMUpdateKeyUpdate) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.NLMContract.(*_NLM).getLengthInBits(ctx))

	// Simple field (controlFlags)
	lengthInBits += m.ControlFlags.GetLengthInBits(ctx)

	// Optional Field (set1KeyRevision)
	if m.Set1KeyRevision != nil {
		lengthInBits += 8
	}

	// Optional Field (set1ActivationTime)
	if m.Set1ActivationTime != nil {
		lengthInBits += 32
	}

	// Optional Field (set1ExpirationTime)
	if m.Set1ExpirationTime != nil {
		lengthInBits += 32
	}

	// Optional Field (set1KeyCount)
	if m.Set1KeyCount != nil {
		lengthInBits += 8
	}

	// Array field
	if len(m.Set1Keys) > 0 {
		for _curItem, element := range m.Set1Keys {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Set1Keys), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Optional Field (set2KeyRevision)
	if m.Set2KeyRevision != nil {
		lengthInBits += 8
	}

	// Optional Field (set2ActivationTime)
	if m.Set2ActivationTime != nil {
		lengthInBits += 32
	}

	// Optional Field (set2ExpirationTime)
	if m.Set2ExpirationTime != nil {
		lengthInBits += 32
	}

	// Optional Field (set2KeyCount)
	if m.Set2KeyCount != nil {
		lengthInBits += 8
	}

	// Array field
	if len(m.Set2Keys) > 0 {
		for _curItem, element := range m.Set2Keys {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Set2Keys), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_NLMUpdateKeyUpdate) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NLMUpdateKeyUpdate) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_NLM, apduLength uint16) (__nLMUpdateKeyUpdate NLMUpdateKeyUpdate, err error) {
	m.NLMContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NLMUpdateKeyUpdate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NLMUpdateKeyUpdate")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	controlFlags, err := ReadSimpleField[NLMUpdateKeyUpdateControlFlags](ctx, "controlFlags", ReadComplex[NLMUpdateKeyUpdateControlFlags](NLMUpdateKeyUpdateControlFlagsParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'controlFlags' field"))
	}
	m.ControlFlags = controlFlags

	var set1KeyRevision *byte
	set1KeyRevision, err = ReadOptionalField[byte](ctx, "set1KeyRevision", ReadByte(readBuffer, 8), controlFlags.GetSet1KeyRevisionActivationTimeExpirationTimePresent())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1KeyRevision' field"))
	}
	m.Set1KeyRevision = set1KeyRevision

	var set1ActivationTime *uint32
	set1ActivationTime, err = ReadOptionalField[uint32](ctx, "set1ActivationTime", ReadUnsignedInt(readBuffer, uint8(32)), controlFlags.GetSet1KeyRevisionActivationTimeExpirationTimePresent())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1ActivationTime' field"))
	}
	m.Set1ActivationTime = set1ActivationTime

	var set1ExpirationTime *uint32
	set1ExpirationTime, err = ReadOptionalField[uint32](ctx, "set1ExpirationTime", ReadUnsignedInt(readBuffer, uint8(32)), controlFlags.GetSet1KeyCountKeyParametersPresent())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1ExpirationTime' field"))
	}
	m.Set1ExpirationTime = set1ExpirationTime

	var set1KeyCount *uint8
	set1KeyCount, err = ReadOptionalField[uint8](ctx, "set1KeyCount", ReadUnsignedByte(readBuffer, uint8(8)), controlFlags.GetSet1KeyCountKeyParametersPresent())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1KeyCount' field"))
	}
	m.Set1KeyCount = set1KeyCount

	set1Keys, err := ReadCountArrayField[NLMUpdateKeyUpdateKeyEntry](ctx, "set1Keys", ReadComplex[NLMUpdateKeyUpdateKeyEntry](NLMUpdateKeyUpdateKeyEntryParseWithBuffer, readBuffer), uint64(utils.InlineIf(bool((set1KeyCount) != (nil)), func() any { return int32((*set1KeyCount)) }, func() any { return int32(int32(0)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1Keys' field"))
	}
	m.Set1Keys = set1Keys

	var set2KeyRevision *byte
	set2KeyRevision, err = ReadOptionalField[byte](ctx, "set2KeyRevision", ReadByte(readBuffer, 8), controlFlags.GetSet1KeyRevisionActivationTimeExpirationTimePresent())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2KeyRevision' field"))
	}
	m.Set2KeyRevision = set2KeyRevision

	var set2ActivationTime *uint32
	set2ActivationTime, err = ReadOptionalField[uint32](ctx, "set2ActivationTime", ReadUnsignedInt(readBuffer, uint8(32)), controlFlags.GetSet1KeyRevisionActivationTimeExpirationTimePresent())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2ActivationTime' field"))
	}
	m.Set2ActivationTime = set2ActivationTime

	var set2ExpirationTime *uint32
	set2ExpirationTime, err = ReadOptionalField[uint32](ctx, "set2ExpirationTime", ReadUnsignedInt(readBuffer, uint8(32)), controlFlags.GetSet1KeyCountKeyParametersPresent())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2ExpirationTime' field"))
	}
	m.Set2ExpirationTime = set2ExpirationTime

	var set2KeyCount *uint8
	set2KeyCount, err = ReadOptionalField[uint8](ctx, "set2KeyCount", ReadUnsignedByte(readBuffer, uint8(8)), controlFlags.GetSet1KeyCountKeyParametersPresent())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2KeyCount' field"))
	}
	m.Set2KeyCount = set2KeyCount

	set2Keys, err := ReadCountArrayField[NLMUpdateKeyUpdateKeyEntry](ctx, "set2Keys", ReadComplex[NLMUpdateKeyUpdateKeyEntry](NLMUpdateKeyUpdateKeyEntryParseWithBuffer, readBuffer), uint64(utils.InlineIf(bool((set1KeyCount) != (nil)), func() any { return int32((*set1KeyCount)) }, func() any { return int32(int32(0)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2Keys' field"))
	}
	m.Set2Keys = set2Keys

	if closeErr := readBuffer.CloseContext("NLMUpdateKeyUpdate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NLMUpdateKeyUpdate")
	}

	return m, nil
}

func (m *_NLMUpdateKeyUpdate) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NLMUpdateKeyUpdate) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NLMUpdateKeyUpdate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NLMUpdateKeyUpdate")
		}

		if err := WriteSimpleField[NLMUpdateKeyUpdateControlFlags](ctx, "controlFlags", m.GetControlFlags(), WriteComplex[NLMUpdateKeyUpdateControlFlags](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'controlFlags' field")
		}

		if err := WriteOptionalField[byte](ctx, "set1KeyRevision", m.GetSet1KeyRevision(), WriteByte(writeBuffer, 8), true); err != nil {
			return errors.Wrap(err, "Error serializing 'set1KeyRevision' field")
		}

		if err := WriteOptionalField[uint32](ctx, "set1ActivationTime", m.GetSet1ActivationTime(), WriteUnsignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'set1ActivationTime' field")
		}

		if err := WriteOptionalField[uint32](ctx, "set1ExpirationTime", m.GetSet1ExpirationTime(), WriteUnsignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'set1ExpirationTime' field")
		}

		if err := WriteOptionalField[uint8](ctx, "set1KeyCount", m.GetSet1KeyCount(), WriteUnsignedByte(writeBuffer, 8), true); err != nil {
			return errors.Wrap(err, "Error serializing 'set1KeyCount' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "set1Keys", m.GetSet1Keys(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'set1Keys' field")
		}

		if err := WriteOptionalField[byte](ctx, "set2KeyRevision", m.GetSet2KeyRevision(), WriteByte(writeBuffer, 8), true); err != nil {
			return errors.Wrap(err, "Error serializing 'set2KeyRevision' field")
		}

		if err := WriteOptionalField[uint32](ctx, "set2ActivationTime", m.GetSet2ActivationTime(), WriteUnsignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'set2ActivationTime' field")
		}

		if err := WriteOptionalField[uint32](ctx, "set2ExpirationTime", m.GetSet2ExpirationTime(), WriteUnsignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'set2ExpirationTime' field")
		}

		if err := WriteOptionalField[uint8](ctx, "set2KeyCount", m.GetSet2KeyCount(), WriteUnsignedByte(writeBuffer, 8), true); err != nil {
			return errors.Wrap(err, "Error serializing 'set2KeyCount' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "set2Keys", m.GetSet2Keys(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'set2Keys' field")
		}

		if popErr := writeBuffer.PopContext("NLMUpdateKeyUpdate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NLMUpdateKeyUpdate")
		}
		return nil
	}
	return m.NLMContract.(*_NLM).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NLMUpdateKeyUpdate) IsNLMUpdateKeyUpdate() {}

func (m *_NLMUpdateKeyUpdate) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NLMUpdateKeyUpdate) deepCopy() *_NLMUpdateKeyUpdate {
	if m == nil {
		return nil
	}
	_NLMUpdateKeyUpdateCopy := &_NLMUpdateKeyUpdate{
		m.NLMContract.(*_NLM).deepCopy(),
		utils.DeepCopy[NLMUpdateKeyUpdateControlFlags](m.ControlFlags),
		utils.CopyPtr[byte](m.Set1KeyRevision),
		utils.CopyPtr[uint32](m.Set1ActivationTime),
		utils.CopyPtr[uint32](m.Set1ExpirationTime),
		utils.CopyPtr[uint8](m.Set1KeyCount),
		utils.DeepCopySlice[NLMUpdateKeyUpdateKeyEntry, NLMUpdateKeyUpdateKeyEntry](m.Set1Keys),
		utils.CopyPtr[byte](m.Set2KeyRevision),
		utils.CopyPtr[uint32](m.Set2ActivationTime),
		utils.CopyPtr[uint32](m.Set2ExpirationTime),
		utils.CopyPtr[uint8](m.Set2KeyCount),
		utils.DeepCopySlice[NLMUpdateKeyUpdateKeyEntry, NLMUpdateKeyUpdateKeyEntry](m.Set2Keys),
	}
	_NLMUpdateKeyUpdateCopy.NLMContract.(*_NLM)._SubType = m
	return _NLMUpdateKeyUpdateCopy
}

func (m *_NLMUpdateKeyUpdate) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
