/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetAuthenticationFactorType {
  UNDEFINED((short) 0),
  ERROR((short) 1),
  CUSTOM((short) 2),
  SIMPLE_NUMBER16((short) 3),
  SIMPLE_NUMBER32((short) 4),
  SIMPLE_NUMBER56((short) 5),
  SIMPLE_ALPHA_NUMERIC((short) 6),
  ABA_TRACK2((short) 7),
  WIEGAND26((short) 8),
  WIEGAND37((short) 9),
  WIEGAND37_FACILITY((short) 10),
  FACILITY16_CARD32((short) 11),
  FACILITY32_CARD32((short) 12),
  FASC_N((short) 13),
  FASC_N_BCD((short) 14),
  FASC_N_LARGE((short) 15),
  FASC_N_LARGE_BCD((short) 16),
  GSA75((short) 17),
  CHUID((short) 18),
  CHUID_FULL((short) 19),
  GUID((short) 20),
  CBEFF_A((short) 21),
  CBEFF_B((short) 22),
  CBEFF_C((short) 23),
  USER_PASSWORD((short) 24);
  private static final Map<Short, BACnetAuthenticationFactorType> map;

  static {
    map = new HashMap<>();
    for (BACnetAuthenticationFactorType value : BACnetAuthenticationFactorType.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  BACnetAuthenticationFactorType(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static BACnetAuthenticationFactorType enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
