/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AxisInformation extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 12081;
  }

  // Properties.
  protected final EUInformation engineeringUnits;
  protected final Range eURange;
  protected final LocalizedText title;
  protected final AxisScaleEnumeration axisScaleType;
  protected final List<Double> axisSteps;

  public AxisInformation(
      EUInformation engineeringUnits,
      Range eURange,
      LocalizedText title,
      AxisScaleEnumeration axisScaleType,
      List<Double> axisSteps) {
    super();
    this.engineeringUnits = engineeringUnits;
    this.eURange = eURange;
    this.title = title;
    this.axisScaleType = axisScaleType;
    this.axisSteps = axisSteps;
  }

  public EUInformation getEngineeringUnits() {
    return engineeringUnits;
  }

  public Range getEURange() {
    return eURange;
  }

  public LocalizedText getTitle() {
    return title;
  }

  public AxisScaleEnumeration getAxisScaleType() {
    return axisScaleType;
  }

  public List<Double> getAxisSteps() {
    return axisSteps;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AxisInformation");

    // Simple Field (engineeringUnits)
    writeSimpleField("engineeringUnits", engineeringUnits, writeComplex(writeBuffer));

    // Simple Field (eURange)
    writeSimpleField("eURange", eURange, writeComplex(writeBuffer));

    // Simple Field (title)
    writeSimpleField("title", title, writeComplex(writeBuffer));

    // Simple Field (axisScaleType)
    writeSimpleEnumField(
        "axisScaleType",
        "AxisScaleEnumeration",
        axisScaleType,
        writeEnum(
            AxisScaleEnumeration::getValue,
            AxisScaleEnumeration::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Implicit Field (noOfAxisSteps) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfAxisSteps = (int) ((((getAxisSteps()) == (null)) ? -(1) : COUNT(getAxisSteps())));
    writeImplicitField("noOfAxisSteps", noOfAxisSteps, writeSignedInt(writeBuffer, 32));

    // Array Field (axisSteps)
    writeSimpleTypeArrayField("axisSteps", axisSteps, writeDouble(writeBuffer, 64));

    writeBuffer.popContext("AxisInformation");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AxisInformation _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (engineeringUnits)
    lengthInBits += engineeringUnits.getLengthInBits();

    // Simple field (eURange)
    lengthInBits += eURange.getLengthInBits();

    // Simple field (title)
    lengthInBits += title.getLengthInBits();

    // Simple field (axisScaleType)
    lengthInBits += 32;

    // Implicit Field (noOfAxisSteps)
    lengthInBits += 32;

    // Array field
    if (axisSteps != null) {
      lengthInBits += 64 * axisSteps.size();
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("AxisInformation");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    EUInformation engineeringUnits =
        readSimpleField(
            "engineeringUnits",
            readComplex(
                () ->
                    (EUInformation) ExtensionObjectDefinition.staticParse(readBuffer, (int) (889)),
                readBuffer));

    Range eURange =
        readSimpleField(
            "eURange",
            readComplex(
                () -> (Range) ExtensionObjectDefinition.staticParse(readBuffer, (int) (886)),
                readBuffer));

    LocalizedText title =
        readSimpleField(
            "title", readComplex(() -> LocalizedText.staticParse(readBuffer), readBuffer));

    AxisScaleEnumeration axisScaleType =
        readEnumField(
            "axisScaleType",
            "AxisScaleEnumeration",
            readEnum(AxisScaleEnumeration::enumForValue, readUnsignedLong(readBuffer, 32)));

    int noOfAxisSteps = readImplicitField("noOfAxisSteps", readSignedInt(readBuffer, 32));

    List<Double> axisSteps =
        readCountArrayField("axisSteps", readDouble(readBuffer, 64), noOfAxisSteps);

    readBuffer.closeContext("AxisInformation");
    // Create the instance
    return new AxisInformationBuilderImpl(
        engineeringUnits, eURange, title, axisScaleType, axisSteps);
  }

  public static class AxisInformationBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final EUInformation engineeringUnits;
    private final Range eURange;
    private final LocalizedText title;
    private final AxisScaleEnumeration axisScaleType;
    private final List<Double> axisSteps;

    public AxisInformationBuilderImpl(
        EUInformation engineeringUnits,
        Range eURange,
        LocalizedText title,
        AxisScaleEnumeration axisScaleType,
        List<Double> axisSteps) {
      this.engineeringUnits = engineeringUnits;
      this.eURange = eURange;
      this.title = title;
      this.axisScaleType = axisScaleType;
      this.axisSteps = axisSteps;
    }

    public AxisInformation build() {
      AxisInformation axisInformation =
          new AxisInformation(engineeringUnits, eURange, title, axisScaleType, axisSteps);
      return axisInformation;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AxisInformation)) {
      return false;
    }
    AxisInformation that = (AxisInformation) o;
    return (getEngineeringUnits() == that.getEngineeringUnits())
        && (getEURange() == that.getEURange())
        && (getTitle() == that.getTitle())
        && (getAxisScaleType() == that.getAxisScaleType())
        && (getAxisSteps() == that.getAxisSteps())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getEngineeringUnits(),
        getEURange(),
        getTitle(),
        getAxisScaleType(),
        getAxisSteps());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
