/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TlvProfibusSubTypePortStatus extends TlvOrgSpecificProfibusUnit implements Message {

  // Accessors for discriminator values.
  public TlvProfibusSubType getSubType() {
    return TlvProfibusSubType.PORT_STATUS;
  }

  // Properties.
  protected final int rtClass2PortStatus;
  protected final boolean preample;
  protected final boolean fragmentation;
  protected final byte rtClass3PortStatus;

  // Reserved Fields
  private Byte reservedField0;
  private Short reservedField1;

  public TlvProfibusSubTypePortStatus(
      int rtClass2PortStatus, boolean preample, boolean fragmentation, byte rtClass3PortStatus) {
    super();
    this.rtClass2PortStatus = rtClass2PortStatus;
    this.preample = preample;
    this.fragmentation = fragmentation;
    this.rtClass3PortStatus = rtClass3PortStatus;
  }

  public int getRtClass2PortStatus() {
    return rtClass2PortStatus;
  }

  public boolean getPreample() {
    return preample;
  }

  public boolean getFragmentation() {
    return fragmentation;
  }

  public byte getRtClass3PortStatus() {
    return rtClass3PortStatus;
  }

  @Override
  protected void serializeTlvOrgSpecificProfibusUnitChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TlvProfibusSubTypePortStatus");

    // Simple Field (rtClass2PortStatus)
    writeSimpleField("rtClass2PortStatus", rtClass2PortStatus, writeUnsignedInt(writeBuffer, 16));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0x00,
        writeUnsignedByte(writeBuffer, 2));

    // Simple Field (preample)
    writeSimpleField("preample", preample, writeBoolean(writeBuffer));

    // Simple Field (fragmentation)
    writeSimpleField("fragmentation", fragmentation, writeBoolean(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 9));

    // Simple Field (rtClass3PortStatus)
    writeSimpleField("rtClass3PortStatus", rtClass3PortStatus, writeUnsignedByte(writeBuffer, 3));

    writeBuffer.popContext("TlvProfibusSubTypePortStatus");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TlvProfibusSubTypePortStatus _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (rtClass2PortStatus)
    lengthInBits += 16;

    // Reserved Field (reserved)
    lengthInBits += 2;

    // Simple field (preample)
    lengthInBits += 1;

    // Simple field (fragmentation)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 9;

    // Simple field (rtClass3PortStatus)
    lengthInBits += 3;

    return lengthInBits;
  }

  public static TlvOrgSpecificProfibusUnitBuilder staticParseTlvOrgSpecificProfibusUnitBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("TlvProfibusSubTypePortStatus");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int rtClass2PortStatus = readSimpleField("rtClass2PortStatus", readUnsignedInt(readBuffer, 16));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 2), (byte) 0x00);

    boolean preample = readSimpleField("preample", readBoolean(readBuffer));

    boolean fragmentation = readSimpleField("fragmentation", readBoolean(readBuffer));

    Short reservedField1 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 9), (short) 0x00);

    byte rtClass3PortStatus =
        readSimpleField("rtClass3PortStatus", readUnsignedByte(readBuffer, 3));

    readBuffer.closeContext("TlvProfibusSubTypePortStatus");
    // Create the instance
    return new TlvProfibusSubTypePortStatusBuilderImpl(
        rtClass2PortStatus,
        preample,
        fragmentation,
        rtClass3PortStatus,
        reservedField0,
        reservedField1);
  }

  public static class TlvProfibusSubTypePortStatusBuilderImpl
      implements TlvOrgSpecificProfibusUnit.TlvOrgSpecificProfibusUnitBuilder {
    private final int rtClass2PortStatus;
    private final boolean preample;
    private final boolean fragmentation;
    private final byte rtClass3PortStatus;
    private final Byte reservedField0;
    private final Short reservedField1;

    public TlvProfibusSubTypePortStatusBuilderImpl(
        int rtClass2PortStatus,
        boolean preample,
        boolean fragmentation,
        byte rtClass3PortStatus,
        Byte reservedField0,
        Short reservedField1) {
      this.rtClass2PortStatus = rtClass2PortStatus;
      this.preample = preample;
      this.fragmentation = fragmentation;
      this.rtClass3PortStatus = rtClass3PortStatus;
      this.reservedField0 = reservedField0;
      this.reservedField1 = reservedField1;
    }

    public TlvProfibusSubTypePortStatus build() {
      TlvProfibusSubTypePortStatus tlvProfibusSubTypePortStatus =
          new TlvProfibusSubTypePortStatus(
              rtClass2PortStatus, preample, fragmentation, rtClass3PortStatus);
      tlvProfibusSubTypePortStatus.reservedField0 = reservedField0;
      tlvProfibusSubTypePortStatus.reservedField1 = reservedField1;
      return tlvProfibusSubTypePortStatus;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TlvProfibusSubTypePortStatus)) {
      return false;
    }
    TlvProfibusSubTypePortStatus that = (TlvProfibusSubTypePortStatus) o;
    return (getRtClass2PortStatus() == that.getRtClass2PortStatus())
        && (getPreample() == that.getPreample())
        && (getFragmentation() == that.getFragmentation())
        && (getRtClass3PortStatus() == that.getRtClass3PortStatus())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRtClass2PortStatus(),
        getPreample(),
        getFragmentation(),
        getRtClass3PortStatus());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
