/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyresourcematcher;

import java.util.Comparator;
import java.util.Map;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;

public interface RangerPolicyResourceMatcher {
    public static final Comparator<MatchType> MATCH_TYPE_COMPARATOR = new MatchTypeComparator();

    public void init();

    public void setServiceDef(RangerServiceDef var1);

    public void setPolicy(RangerPolicy var1);

    public void setPolicyResources(Map<String, RangerPolicy.RangerPolicyResource> var1);

    public void setPolicyResources(Map<String, RangerPolicy.RangerPolicyResource> var1, int var2);

    public void setServiceDefHelper(RangerServiceDefHelper var1);

    public void setPluginContext(RangerPluginContext var1);

    public RangerServiceDef getServiceDef();

    public RangerResourceMatcher getResourceMatcher(String var1);

    public boolean isMatch(RangerAccessResource var1, Map<String, Object> var2);

    public boolean isMatch(RangerAccessResource var1, Map<String, RangerAccessRequest.ResourceElementMatchingScope> var2, Map<String, Object> var3);

    public boolean isMatch(Map<String, RangerPolicy.RangerPolicyResource> var1, Map<String, Object> var2);

    public boolean isMatch(Map<String, RangerPolicy.RangerPolicyResource> var1, Map<String, RangerAccessRequest.ResourceElementMatchingScope> var2, Map<String, Object> var3);

    public boolean isMatch(RangerAccessResource var1, MatchScope var2, Map<String, Object> var3);

    public boolean isMatch(RangerAccessResource var1, Map<String, RangerAccessRequest.ResourceElementMatchingScope> var2, MatchScope var3, Map<String, Object> var4);

    public boolean isMatch(RangerPolicy var1, MatchScope var2, Map<String, Object> var3);

    public boolean isMatch(RangerPolicy var1, Map<String, RangerAccessRequest.ResourceElementMatchingScope> var2, MatchScope var3, Map<String, Object> var4);

    public MatchType getMatchType(RangerAccessResource var1, Map<String, Object> var2);

    public MatchType getMatchType(RangerAccessResource var1, Map<String, RangerAccessRequest.ResourceElementMatchingScope> var2, Map<String, Object> var3);

    public boolean isCompleteMatch(RangerAccessResource var1, Map<String, Object> var2);

    public boolean isCompleteMatch(Map<String, RangerPolicy.RangerPolicyResource> var1, Map<String, Object> var2);

    public boolean getNeedsDynamicEval();

    public StringBuilder toString(StringBuilder var1);

    public static class MatchTypeComparator
    implements Comparator<MatchType> {
        @Override
        public int compare(MatchType o1, MatchType o2) {
            int ret;
            if (o1 == o2) {
                ret = 0;
            } else {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                switch (o1) {
                    case SELF: {
                        ret = -1;
                        break;
                    }
                    case SELF_AND_ALL_DESCENDANTS: {
                        ret = o2 == MatchType.SELF ? 1 : -1;
                        break;
                    }
                    case ANCESTOR: {
                        ret = o2 == MatchType.SELF || o2 == MatchType.SELF_AND_ALL_DESCENDANTS ? 1 : -1;
                        break;
                    }
                    case DESCENDANT: {
                        ret = o2 == MatchType.NONE ? -1 : 1;
                        break;
                    }
                    default: {
                        ret = 1;
                    }
                }
            }
            return ret;
        }
    }

    public static enum MatchType {
        NONE,
        SELF,
        DESCENDANT,
        ANCESTOR,
        SELF_AND_ALL_DESCENDANTS;

    }

    public static enum MatchScope {
        SELF,
        SELF_OR_DESCENDANT,
        SELF_OR_ANCESTOR,
        DESCENDANT,
        ANCESTOR,
        ANY,
        SELF_AND_ALL_DESCENDANTS;

    }
}

