/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.store.TagStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceTag
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceTag.class);
    public static final String TAG_RESOURCE_NAME = "tag";
    public static final String RANGER_TAG_NAME_EXPIRES_ON = "EXPIRES_ON";
    public static final String RANGER_TAG_EXPIRY_CONDITION_NAME = "accessed-after-expiry";
    private TagStore tagStore;

    @Override
    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public void setTagStore(TagStore tagStore) {
        this.tagStore = tagStore;
    }

    @Override
    public Map<String, Object> validateConfig() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceTag.validateConfig(" + this.serviceName + " )");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("connectivityStatus", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceTag.validateConfig(" + this.serviceName + " ): " + ret);
        }
        return ret;
    }

    @Override
    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceTag.lookupResource(" + context + ")");
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (context != null && StringUtils.equals((String)context.getResourceName(), (String)TAG_RESOURCE_NAME)) {
            try {
                List<String> tags;
                List<String> list = tags = this.tagStore != null ? this.tagStore.getTagTypes() : null;
                if (CollectionUtils.isNotEmpty(tags)) {
                    String valueToMatch;
                    List<String> valuesToExclude;
                    List<String> list2 = valuesToExclude = MapUtils.isNotEmpty(context.getResources()) ? context.getResources().get(TAG_RESOURCE_NAME) : null;
                    if (CollectionUtils.isNotEmpty(valuesToExclude)) {
                        tags.removeAll(valuesToExclude);
                    }
                    if (StringUtils.isNotEmpty((String)(valueToMatch = context.getUserInput()))) {
                        if (!valueToMatch.endsWith("*")) {
                            valueToMatch = valueToMatch + "*";
                        }
                        for (String tag : tags) {
                            if (!FilenameUtils.wildcardMatch((String)tag, (String)valueToMatch)) continue;
                            ret.add(tag);
                        }
                    }
                }
            }
            catch (Exception excp) {
                LOG.error("RangerServiceTag.lookupResource()", (Throwable)excp);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceTag.lookupResource(): tag count=" + ret.size());
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceTag.getDefaultRangerPolicies() ");
        }
        ArrayList<RangerPolicy> ret = new ArrayList();
        boolean isConditionDefFound = false;
        List<RangerServiceDef.RangerPolicyConditionDef> policyConditionDefs = this.serviceDef.getPolicyConditions();
        if (CollectionUtils.isNotEmpty(policyConditionDefs)) {
            for (RangerServiceDef.RangerPolicyConditionDef conditionDef : policyConditionDefs) {
                if (!conditionDef.getName().equals(RANGER_TAG_EXPIRY_CONDITION_NAME)) continue;
                isConditionDefFound = true;
                break;
            }
        }
        if (isConditionDefFound) {
            ret = super.getDefaultRangerPolicies();
            String tagResourceName = null;
            if (!this.serviceDef.getResources().isEmpty()) {
                tagResourceName = this.serviceDef.getResources().get(0).getName();
                for (RangerPolicy defaultPolicy : ret) {
                    RangerPolicy.RangerPolicyResource tagPolicyResource = defaultPolicy.getResources().get(tagResourceName);
                    if (tagPolicyResource == null) continue;
                    String value = RANGER_TAG_NAME_EXPIRES_ON;
                    tagPolicyResource.setValue(value);
                    defaultPolicy.setName(value);
                    defaultPolicy.setDescription("Policy for data with " + value + " tag");
                    List<RangerPolicy.RangerPolicyItem> defaultPolicyItems = defaultPolicy.getPolicyItems();
                    for (RangerPolicy.RangerPolicyItem defaultPolicyItem : defaultPolicyItems) {
                        ArrayList<String> groups = new ArrayList<String>();
                        groups.add("public");
                        defaultPolicyItem.setGroups(groups);
                        ArrayList<RangerPolicy.RangerPolicyItemCondition> policyItemConditions = new ArrayList<RangerPolicy.RangerPolicyItemCondition>();
                        ArrayList<String> values = new ArrayList<String>();
                        values.add("yes");
                        RangerPolicy.RangerPolicyItemCondition policyItemCondition = new RangerPolicy.RangerPolicyItemCondition(RANGER_TAG_EXPIRY_CONDITION_NAME, values);
                        policyItemConditions.add(policyItemCondition);
                        defaultPolicyItem.setConditions(policyItemConditions);
                        defaultPolicyItem.setDelegateAdmin(Boolean.FALSE);
                    }
                    defaultPolicy.setDenyPolicyItems(defaultPolicyItems);
                    defaultPolicy.setPolicyItems(null);
                }
            }
        } else {
            LOG.error("RangerServiceTag.getDefaultRangerPolicies() - Cannot create default TAG policy: Cannot get tagPolicyConditionDef with name=accessed-after-expiry");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceTag.getDefaultRangerPolicies() : " + ret);
        }
        return ret;
    }
}

